package com.biz.crm.assistant.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Index;


/**
 * 工作任务-执行对象
 *
 * @author yangshan
 * @date 2021/3/6 16:19
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_work_task_object")
@CrmTable(name = "sfa_work_task_object" , tableNote = "工作任务-执行对象",indexes = {
        @Index(name = "work_task_object_index1",columnList = "task_id")
})
public class SfaWorkTaskObjectEntity extends CrmExtTenEntity<SfaWorkTaskObjectEntity> {

    /**
     * 工作任务id
     */
    @CrmColumn(name = "task_id", length = 32, note = "工作任务id")
    private String taskId;

    /**
     * 客户编码
     */
    @CrmColumn(name = "customer_code", length = 32, note = "客户编码")
    private String customerCode;

    /**
     * 客户类型
     */
    @CrmColumn(name = "customer_type", length = 32, note = "客户类型")
    private String customerType;

    /**
     * 客户名称
     */
    @CrmColumn(name = "customer_name", length = 32, note = "客户名称")
    private String customerName;
}
