package com.biz.crm.assistant.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 任务相关图片id 实体类
 *
 * @author liuhongming
 * @date 2020-10-15 15:32:29
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_work_task_picture")
@CrmTable(name = "sfa_work_task_picture", tableNote = "任务相关图片id",indexes = {
        @Index(name = "work_task_picture_index1",columnList = "task_id"),
        @Index(name = "work_task_picture_index2",columnList = "business_id")
})
public class SfaWorkTaskPictureEntity extends CrmExtTenEntity<SfaWorkTaskPictureEntity> {

    /**
     * 标题
     */
    @CrmColumn(name = "title", length = 200, note = "标题")
    private String title;

    /**
     * 照片类型
     */
    @CrmColumn(name = "pic_type", length = 32, note = "照片类型")
    private String picType;

    /**
     * 照片路径
     */
    @CrmColumn(name = "pic_path", length = 512, note = "照片路径")
    private String picPath;

    /**
     * 照片地址
     */
    @CrmColumn(name = "pic_url", length = 512, note = "照片地址")
    private String picUrl;

    /**
     * 照片描述
     */
    @CrmColumn(name = "pic_desc", length = 512, note = "照片描述")
    private String picDesc;

    /**
     * 任务id
     */
    @CrmColumn(name = "task_id", length = 32, note = "任务id")
    private String taskId;

    /**
     * 业务明细关联
     */
    @CrmColumn(name = "business_id", length = 32, note = "业务明细关联")
    private String businessId;

}
