package com.biz.crm.assistant.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.assistant.model.SfaWorkTaskObjectEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskObjectReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskObjectRespVo;

import java.util.List;

/**
 * 工作任务-执行对象接口
 * @author yangshan
 * @date 2021/3/6 16:58
 */
public interface ISfaWorkTaskObjectService extends IService<SfaWorkTaskObjectEntity> {
    /**
     * 列表
     *
     * @param reqVo
     * @return
     */
    PageResult<SfaWorkTaskObjectRespVo> findList(SfaWorkTaskObjectReqVo reqVo);

    /**
     * 批量保存
     *
     * @param reqVos
     */
    void save(List<SfaWorkTaskObjectReqVo> reqVos);

    /**
     * 根据任务Id批量删除
     *
     * @param taskIds
     */
    void delete(List<String> taskIds);
}
