package com.biz.crm.assistant.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.assistant.model.SfaVisitStepAbnormalEntity;
import com.biz.crm.assistant.mapper.SfaVisitStepAbnormalMapper;
import com.biz.crm.assistant.service.ISfaVisitStepAbnormalService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.sfa.assistant.resp.SfaVisitStepAbnormalRespVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaVisitStepAbnormalReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;

import javax.annotation.Resource;

/**
 * 拜访（异常提报） 接口实现
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaVisitStepAbnormalServiceExpandImpl")
public class SfaVisitStepAbnormalServiceImpl extends ServiceImpl<SfaVisitStepAbnormalMapper, SfaVisitStepAbnormalEntity> implements ISfaVisitStepAbnormalService {

    @Resource
    private SfaVisitStepAbnormalMapper sfaVisitStepAbnormalMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaVisitStepAbnormalRespVo> findList(SfaVisitStepAbnormalReqVo reqVo){
        Page<SfaVisitStepAbnormalRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaVisitStepAbnormalRespVo> list = sfaVisitStepAbnormalMapper.findList(page, reqVo);
        return PageResult.<SfaVisitStepAbnormalRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaVisitStepAbnormalRespVo
     */
    @Override
    public SfaVisitStepAbnormalRespVo query(SfaVisitStepAbnormalReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaVisitStepAbnormalReqVo reqVo){
        SfaVisitStepAbnormalEntity entity = CrmBeanUtil.copy(reqVo,SfaVisitStepAbnormalEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaVisitStepAbnormalReqVo reqVo){
        SfaVisitStepAbnormalEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaVisitStepAbnormalReqVo reqVo){
        List<SfaVisitStepAbnormalEntity> sfaVisitStepAbnormalEntities = sfaVisitStepAbnormalMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaVisitStepAbnormalEntities)){
            sfaVisitStepAbnormalEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaVisitStepAbnormalEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaVisitStepAbnormalReqVo reqVo){
        //设置状态为启用
        List<SfaVisitStepAbnormalEntity> sfaVisitStepAbnormalEntities = sfaVisitStepAbnormalMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaVisitStepAbnormalEntities)){
            sfaVisitStepAbnormalEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitStepAbnormalEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaVisitStepAbnormalReqVo reqVo){
        //设置状态为禁用
        List<SfaVisitStepAbnormalEntity> sfaVisitStepAbnormalEntities = sfaVisitStepAbnormalMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaVisitStepAbnormalEntities)){
                sfaVisitStepAbnormalEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitStepAbnormalEntities);
    }
}
