package com.biz.crm.assistant.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.assistant.model.SfaWorkTaskNoticeEntity;
import com.biz.crm.assistant.mapper.SfaWorkTaskNoticeMapper;
import com.biz.crm.assistant.service.ISfaWorkTaskNoticeService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskNoticeRespVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskNoticeReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;

import javax.annotation.Resource;

/**
 * 工作任务(抄送) 接口实现
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaWorkTaskNoticeServiceExpandImpl")
public class SfaWorkTaskNoticeServiceImpl extends ServiceImpl<SfaWorkTaskNoticeMapper, SfaWorkTaskNoticeEntity> implements ISfaWorkTaskNoticeService {

    @Resource
    private SfaWorkTaskNoticeMapper sfaWorkTaskNoticeMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaWorkTaskNoticeRespVo> findList(SfaWorkTaskNoticeReqVo reqVo){
        Page<SfaWorkTaskNoticeRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaWorkTaskNoticeRespVo> list = sfaWorkTaskNoticeMapper.findList(page, reqVo);
        return PageResult.<SfaWorkTaskNoticeRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaWorkTaskNoticeRespVo
     */
    @Override
    public SfaWorkTaskNoticeRespVo query(SfaWorkTaskNoticeReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaWorkTaskNoticeReqVo reqVo){
        SfaWorkTaskNoticeEntity entity = CrmBeanUtil.copy(reqVo,SfaWorkTaskNoticeEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaWorkTaskNoticeReqVo reqVo){
        SfaWorkTaskNoticeEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaWorkTaskNoticeReqVo reqVo){
        List<SfaWorkTaskNoticeEntity> sfaWorkTaskNoticeEntities = sfaWorkTaskNoticeMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaWorkTaskNoticeEntities)){
            sfaWorkTaskNoticeEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaWorkTaskNoticeEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaWorkTaskNoticeReqVo reqVo){
        //设置状态为启用
        List<SfaWorkTaskNoticeEntity> sfaWorkTaskNoticeEntities = sfaWorkTaskNoticeMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaWorkTaskNoticeEntities)){
            sfaWorkTaskNoticeEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaWorkTaskNoticeEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaWorkTaskNoticeReqVo reqVo){
        //设置状态为禁用
        List<SfaWorkTaskNoticeEntity> sfaWorkTaskNoticeEntities = sfaWorkTaskNoticeMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaWorkTaskNoticeEntities)){
                sfaWorkTaskNoticeEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaWorkTaskNoticeEntities);
    }
}
