package com.biz.crm.assistant.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.assistant.mapper.SfaWorkTaskObjectMapper;
import com.biz.crm.assistant.model.SfaWorkTaskObjectEntity;
import com.biz.crm.assistant.service.ISfaWorkTaskObjectService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskObjectReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskObjectRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.List;

/**
 * 工作任务-执行对象接口实现
 *
 * @author yangshan
 * @date 2021/3/6 17:04
 */
@Service
@Slf4j
public class SfaWorkTaskObjectServiceImpl extends ServiceImpl<SfaWorkTaskObjectMapper, SfaWorkTaskObjectEntity> implements ISfaWorkTaskObjectService {

    @Autowired
    private SfaWorkTaskObjectMapper sfaWorkTaskObjectMapper;

    /**
     * 列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaWorkTaskObjectRespVo> findList(SfaWorkTaskObjectReqVo reqVo) {
        Page<SfaWorkTaskObjectRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaWorkTaskObjectRespVo> list = sfaWorkTaskObjectMapper.findList(page, reqVo);
        return PageResult.<SfaWorkTaskObjectRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 批量保存
     *
     * @param reqVos
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(List<SfaWorkTaskObjectReqVo> reqVos) {
        reqVos.forEach(this::doCheck);
        List<SfaWorkTaskObjectEntity> entities = CrmBeanUtil.copyList(reqVos, SfaWorkTaskObjectEntity.class);
        this.saveBatch(entities);
    }

    /**
     * 根据任务Id批量删除
     *
     * @param taskIds
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delete(List<String> taskIds) {
        AssertUtils.isNotEmpty(taskIds, "任务编码不能为空");
        this.removeByIds(taskIds);
    }

    /**
     * 参数校验
     * @param reqVo
     */
    private void doCheck(SfaWorkTaskObjectReqVo reqVo){
        AssertUtils.isNotEmpty(reqVo.getTaskId(), "任务id不能为空");
        AssertUtils.isNotEmpty(reqVo.getCustomerCode(), "客户编码不能为空");
        AssertUtils.isNotEmpty(reqVo.getCustomerName(), "客户名称不能为空");
        AssertUtils.isNotEmpty(reqVo.getCustomerType(), "客户类型不能为空");
    }
}
