package com.biz.crm.assistant.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.assistant.mapper.SfaWorkTaskPictureMapper;
import com.biz.crm.assistant.mapper.SfaWorkTaskReceveMapper;
import com.biz.crm.assistant.mapper.SfaWorkTaskReleaseMapper;
import com.biz.crm.assistant.model.SfaWorkTaskPictureEntity;
import com.biz.crm.assistant.model.SfaWorkTaskReceveEntity;
import com.biz.crm.assistant.model.SfaWorkTaskReleaseEntity;
import com.biz.crm.assistant.service.ISfaWorkTaskObjectService;
import com.biz.crm.assistant.service.ISfaWorkTaskPictureService;
import com.biz.crm.assistant.service.ISfaWorkTaskReceveService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmAttachment;
import com.biz.crm.base.attachment.SfaAttachmentEntity;
import com.biz.crm.base.utils.SfaAttachmentUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.enums.SfaTaskPictureEnum;
import com.biz.crm.enums.SfaTaskReleaseEnum;
import com.biz.crm.enums.SfaTaskStatusEnum;
import com.biz.crm.eunm.sfa.AttachmentBizTypeEnum;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskObjectReqVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskPictureReqVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskReceveReqVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskReportReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.*;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 工作任务(接收) 接口实现
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Slf4j
@Service
@Transactional(rollbackFor = Exception.class)
@ConditionalOnMissingBean(name = "SfaWorkTaskReceveServiceExpandImpl")
public class SfaWorkTaskReceveServiceImpl extends ServiceImpl<SfaWorkTaskReceveMapper, SfaWorkTaskReceveEntity> implements ISfaWorkTaskReceveService {

    @Resource
    private SfaWorkTaskReceveMapper sfaWorkTaskReceveMapper;

    @Resource
    private SfaWorkTaskReleaseMapper sfaWorkTaskReleaseMapper;

    @Resource
    private MdmOrgFeign mdmOrgFeign;

    @Resource
    private ISfaWorkTaskObjectService sfaWorkTaskObjectService;

    /**
     * 列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaWorkTaskReceveRespVo> findList(SfaWorkTaskReceveReqVo reqVo) throws Exception {
        //获取当前登录人的账号
        UserRedis user = UserUtils.getUser();
        String username = user.getUsername();

        reqVo.setReceverCode(username);
        reqVo.setCreateOrgCode(user.getOrgcode());
        reqVo.setCreatePosCode(user.getPoscode());
        //关闭分页 查全部
        Page<SfaWorkTaskReceveRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaWorkTaskReceveRespVo> list = sfaWorkTaskReceveMapper.findList(page, reqVo);
        return PageResult.<SfaWorkTaskReceveRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public PageResult<SfaWorkTaskReceveRespVo> findDayList(SfaWorkTaskReceveReqVo reqVo) throws Exception {
        AssertUtils.isNotEmpty(reqVo.getQueryDate(),"请输入日期");
        AssertUtils.isNotEmpty(reqVo.getReceverCode(),"要查询的账号不能为空");
        //获取当前登录人
        UserRedis user = UserUtils.getUser();
        String username = user.getUsername();
        Page<SfaWorkTaskReceveRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaWorkTaskReceveRespVo> list = sfaWorkTaskReceveMapper.findOffTheStocks(page,reqVo);
        //置空非当前登录角色的id
        Iterator<SfaWorkTaskReceveRespVo> iterator = list.iterator();
        int sum = 0;
        while (iterator.hasNext()) {
            SfaWorkTaskReceveRespVo next = iterator.next();
            if(SfaTaskStatusEnum.WAIT_EXECUTE.getCode().equals(next.getExecuteStatus())) {
                if (!username.equals(next.getReceverCode())){
                    next.setCheckStatus("0");
                }else{
                    next.setCheckStatus("1");
                }
            }
        }

        return PageResult.<SfaWorkTaskReceveRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public Map findDayPlan(SfaWorkTaskReceveReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getQueryDate(),"请输入日期");
        AssertUtils.isNotEmpty(reqVo.getReceverCode(),"要查询的账号不能为空");
        List<String> date = sfaWorkTaskReceveMapper.findStatusByQueryDate(reqVo.getCreatePosCode(),reqVo.getCreateOrgCode(),
                reqVo.getQueryDate(), reqVo.getReceverCode());
        int sum = 0;
        int size = 0;
        if(!CollectionUtil.listEmpty(date)){
            size = date.size();
        }
        for (String s : date) {
            if(SfaTaskStatusEnum.EXECUTE_LODING.getCode().equals(s)){
                sum++;
            }
        }
        Map<String,Integer> map = new HashMap<>(2);
        map.put("molecule",sum);
        map.put("denominator",size);
        return map;
    }



    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    @Override
    public void save(SfaWorkTaskReceveReqVo reqVo) {
        SfaWorkTaskReceveEntity entity = CrmBeanUtil.copy(reqVo, SfaWorkTaskReceveEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    @Override
    public void update(SfaWorkTaskReceveReqVo reqVo) {
        this.checkSfaWorkRrceverReqVo(reqVo);
        SfaWorkTaskReceveEntity entity = this.getById(reqVo.getReceveId());
        if (Objects.isNull(entity)) {
            throw new BusinessException("当前记录无相关数据");
        }
        entity.setAddress(reqVo.getAddress());
        entity.setSummary(reqVo.getSummary());
        entity.setExecuteStatus(reqVo.getExecuteStatus());
        this.updateById(entity);
        // 改变主数据状态以及百分比
        List<SfaWorkTaskReceveRespVo> byTaskId = this.sfaWorkTaskReceveMapper.findListByTaskId(entity.getTaskId());
        if (byTaskId != null && byTaskId.size() > 0) {
            String[] status = this.getStatus(byTaskId, entity.getId(), reqVo.getExecuteStatus());
            SfaWorkTaskReleaseEntity releaseEntity = new SfaWorkTaskReleaseEntity();
            releaseEntity.setId(entity.getTaskId());
            releaseEntity.setProgress(status[0]);
            releaseEntity.setTaskStatus(status[1]);

            this.sfaWorkTaskReleaseMapper.updateById(releaseEntity);
        }

        List<SfaWorkTaskPictureReqVo> pictures = reqVo.getPictures();
        SfaAttachmentUtil.insert(CrmAttachment.convertTaskPic(pictures), AttachmentBizTypeEnum.TASK_EXECUTE, entity.getId());

    }


    /**
     * 查询工作任务报表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaWorkTaskReportRespVo> findSfaWorkTaskReportList(SfaWorkTaskReportReqVo reqVo) {
        Page<SfaWorkTaskReportRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        String orgCode = UserUtils.getUser().getOrgcode();
        if (StringUtils.isEmpty(orgCode)) {
            return PageResult.<SfaWorkTaskReportRespVo>builder()
                    .data(Lists.newArrayList())
                    .count(page.getTotal())
                    .build();
        }
//        MdmOrgReqVo mdmOrgReqVo = new MdmOrgReqVo() {{
//            this.setOrgCode(orgCode);
//        }};
//        Result<List<MdmOrgRespVo>> result = mdmOrgFeign.findSingleChildrenOrgList(mdmOrgReqVo);
//        List<String> orgCodeList = null;
//        if (result != null && result.isSuccess()) {
//            if (CollectionUtil.listNotEmptyNotSizeZero(result.getResult())) {
//                orgCodeList = result.getResult().stream().map(MdmOrgRespVo::getOrgCode).distinct().collect(Collectors.toList());
//                reqVo.setOrgCodeList(orgCodeList);
//            } else {
//                orgCodeList = Lists.newArrayList(orgCode);
//                reqVo.setOrgCodeList(orgCodeList);
//            }
//        }
        List<SfaWorkTaskReportRespVo> sfaWorkTaskReportRespVoList = sfaWorkTaskReleaseMapper.findSfaWorkTaskReportList(page, reqVo);
        sfaWorkTaskReportRespVoList.forEach(data -> {
            List<SfaAttachmentEntity> executePicUrlList = SfaAttachmentUtil.getList(AttachmentBizTypeEnum.TASK_EXECUTE.getVal(),data.getId());
            if (CollectionUtil.listNotEmptyNotSizeZero(executePicUrlList)) {
                data.setExecuteTaskPicList(executePicUrlList.stream().map(SfaAttachmentEntity::getUrl).collect(Collectors.toList()));
            }
            List<SfaAttachmentEntity> sendTaskPicList = SfaAttachmentUtil.getList(AttachmentBizTypeEnum.TASK_ADD.getVal(),data.getTaskId());
            if (CollectionUtil.listNotEmptyNotSizeZero(sendTaskPicList)) {
                data.setSendTaskPicList(sendTaskPicList.stream().map(SfaAttachmentEntity::getUrl).collect(Collectors.toList()));
            }
        });
        return PageResult.<SfaWorkTaskReportRespVo>builder()
                .data(sfaWorkTaskReportRespVoList)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查看任务报表明细
     * @param id
     * @return
     */
    @Override
    public SfaWorkTaskReportRespVo findSfaWorkTaskReportById(String id) {
        if (!StringUtils.isNotEmpty(id)){
            throw new BusinessException("数据主键不能为空");
        }
        List<SfaWorkTaskReportRespVo> sfaWorkTaskReportRespVoList = this.findSfaWorkTaskReportList(new SfaWorkTaskReportReqVo(){{this.setId(id);}}).getData();
        SfaWorkTaskReportRespVo sfaWorkTaskReportRespVo = null;
        if (CollectionUtil.listNotEmptyNotSizeZero(sfaWorkTaskReportRespVoList)){
            sfaWorkTaskReportRespVo = sfaWorkTaskReportRespVoList.get(0);
        }
        return sfaWorkTaskReportRespVo;
    }


    /**
     * 编辑参数验证
     *
     * @param reqVo
     */
    private void checkSfaWorkRrceverReqVo(SfaWorkTaskReceveReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getReceveId(), "入参receveId不能为空");
        if (SfaTaskStatusEnum.EXECUTE_LODING.getCode().equals(reqVo.getExecuteStatus())){
        AssertUtils.isNotEmpty(reqVo.getSummary(), "请输入执行总结");
        }
        AssertUtils.isNotEmpty(reqVo.getExecuteStatus(), "请输入执行结果");
    }

    /**
     * 接受任务 状态识别
     *
     * @return
     */
    private String[] getStatus(List<SfaWorkTaskReceveRespVo> receveRespVos, String id, String exStatus) {
        // 0待执行 1已完成 2已回绝 3已过期

        //待执行
        int toPerformNum = 0;
        //已完成
        int offTheStocksNum = 0;
        //已拒绝
        int submittedNum = 0;
        //已过期
        int haveExpiredNum = 0;


        //创建长度为2的数组
        //[0]:已完成/总数 [1]:状态
        String[] list = new String[]{"", ""};
        int size = receveRespVos.size();
        Iterator<SfaWorkTaskReceveRespVo> iterator = receveRespVos.iterator();
        while (iterator.hasNext()) {
            SfaWorkTaskReceveRespVo next = iterator.next();
            if (id.equals(next.getReceveId())) {
                next.setExecuteStatus(exStatus);
            }
            switch (next.getExecuteStatus()) {
                case "0":
                    toPerformNum++;
                    break;
                case "1":
                    offTheStocksNum++;
                    break;
                case "2":
                    submittedNum++;
                    break;
                case "3":
                    haveExpiredNum++;
                    break;
                default:
                    break;
            }
        }
        //已完成
        boolean b = offTheStocksNum == size || (offTheStocksNum + submittedNum) == size;
        if (offTheStocksNum > 0 && b) {
            list[0] = size + "/" + size;
            list[1] = SfaTaskReleaseEnum.EXECUTE_LODING.getCode();
            return list;
        }
        //部分完成
        if (offTheStocksNum > 0) {

            list[0] = offTheStocksNum + "/" + size;
            list[1] = SfaTaskReleaseEnum.PARTLY_COMPLETED.getCode();
            return list;
        }

        //待执行
        if (offTheStocksNum == 0 && toPerformNum > 0) {
            list[0] = submittedNum+"/" + size;
            list[1] = SfaTaskReleaseEnum.WAIT_EXECUTE.getCode();
            return list;
        }
        //已拒绝
        if (submittedNum == size) {
            list[0] = size+"/" + size;
            list[1] = SfaTaskReleaseEnum.ALREADY_FINISH.getCode();
            return list;
        }
        //已过期
        if (haveExpiredNum == size) {
            list[0] = "0/" + size;
            list[1] = SfaTaskReleaseEnum.PAST_DUE.getCode();
            return list;
        }
        //未完成
        if (offTheStocksNum == 0 && toPerformNum == 0) {
            list[0] = offTheStocksNum + "/" + size;
            list[1] = SfaTaskReleaseEnum.UNFINISHED.getCode();
            return list;
        }

        return list;
    }

}
