package com.biz.crm.assistant.service.impl;

import com.biz.crm.assistant.mapper.SfaWorkTaskPictureMapper;
import com.biz.crm.assistant.mapper.SfaWorkTaskReceveMapper;
import com.biz.crm.assistant.model.SfaWorkTaskPictureEntity;
import com.biz.crm.assistant.model.SfaWorkTaskReceveEntity;
import com.biz.crm.assistant.service.ISfaWorkTaskObjectService;
import com.biz.crm.assistant.service.ISfaWorkTaskPictureService;
import com.biz.crm.assistant.service.ISfaWorkTaskReceveService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmAttachment;
import com.biz.crm.base.attachment.SfaAttachmentEntity;
import com.biz.crm.base.utils.SfaAttachmentUtil;
import com.biz.crm.enums.SfaTaskPictureEnum;
import com.biz.crm.enums.SfaTaskReleaseEnum;
import com.biz.crm.enums.SfaTaskStatusEnum;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.AttachmentBizTypeEnum;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.sfa.assistant.req.*;
import com.biz.crm.nebular.sfa.assistant.resp.*;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.assistant.model.SfaWorkTaskReleaseEntity;
import com.biz.crm.assistant.mapper.SfaWorkTaskReleaseMapper;
import com.biz.crm.assistant.service.ISfaWorkTaskReleaseService;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;

/**
 * 工作任务(发布) 接口实现
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Slf4j
@Service
@Transactional(rollbackFor = Exception.class)
@ConditionalOnMissingBean(name = "SfaWorkTaskReleaseServiceExpandImpl")
public class SfaWorkTaskReleaseServiceImpl extends ServiceImpl<SfaWorkTaskReleaseMapper, SfaWorkTaskReleaseEntity> implements ISfaWorkTaskReleaseService {

    @Resource
    private SfaWorkTaskReleaseMapper sfaWorkTaskReleaseMapper;

    @Resource
    private SfaWorkTaskReceveMapper sfaWorkTaskReceveMapper;

    @Resource
    private ISfaWorkTaskPictureService sfaWorkTaskPictureService;

    @Resource
    private SfaWorkTaskPictureMapper sfaWorkTaskPictureMapper;

    @Autowired
    private ISfaWorkTaskReceveService sfaWorkTaskReceveService;

    @Autowired
    private ISfaWorkTaskObjectService sfaWorkTaskObjectService;

    /**
     * 列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaWorkTaskReleaseRespVo> findList(SfaWorkTaskReleaseReqVo reqVo) {
        Page<SfaWorkTaskReleaseRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaWorkTaskReleaseRespVo> list = sfaWorkTaskReleaseMapper.findList(page, reqVo);
        return PageResult.<SfaWorkTaskReleaseRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 全部列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaWorkTaskReleaseRespVo> findListAll(SfaWorkTaskReleaseReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        reqVo.setCreateCode(user.getUsername());
        reqVo.setCreateOrgCode(user.getOrgcode());
        reqVo.setCreatePosCode(user.getPoscode());
        Page<SfaWorkTaskReleaseRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaWorkTaskReleaseRespVo> list = sfaWorkTaskReleaseMapper.findListAll(page, reqVo);
        Map<String, String> map = new HashMap<>();
        Iterator<SfaWorkTaskReleaseRespVo> iterator = list.iterator();
        while (iterator.hasNext()) {
            SfaWorkTaskReleaseRespVo next = iterator.next();
            String progress = next.getProgress();
            String[] split = progress.split("/");
            next.setQuantityNum(split[0]);
            String sum = split[1];
            next.setSumAll(sum);
            //如果执行任务总人数为1
            if ("1".equals(sum)) {
                map.put(next.getTaskId(), null);
            }
            next.setProgress(this.getPercentage(Integer.valueOf(split[0]), Integer.valueOf(sum)));
        }
        if (!map.isEmpty()) {
            List<SfaWorkTaskReceveRespVo> taskId = sfaWorkTaskReceveMapper.findOneByTaskId(map);
            for (SfaWorkTaskReceveRespVo sfaWorkTaskReceveRespVo : taskId) {
                String receverName = sfaWorkTaskReceveRespVo.getReceverName();
                map.put(sfaWorkTaskReceveRespVo.getTaskId(), receverName);
            }

            for (SfaWorkTaskReleaseRespVo sfaWorkTaskReleaseRespVo : list) {
                sfaWorkTaskReleaseRespVo.setExecutor(map.get(sfaWorkTaskReleaseRespVo.getTaskId()));
            }
        }
        return PageResult.<SfaWorkTaskReleaseRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    private void buildReleasePics(SfaWorkTaskReleaseRespVo one){
        //发布任务时的附件
        List<SfaWorkTaskPictureRespVo> taskAddPic = SfaAttachmentUtil.getList(AttachmentBizTypeEnum.TASK_ADD, one.getTaskId()).stream().map(v -> {
            SfaWorkTaskPictureRespVo temp = new SfaWorkTaskPictureRespVo();
            temp.setPicUrl(v.getUrlPathPrefix());
            temp.setPicPath(v.getUrlPath());
            temp.setTitle(v.getFileName());
            return temp;
        }).collect(Collectors.toList());
        one.setPictures(taskAddPic);
    }
    /**
     * 查询详情
     *
     * @param receveId
     * @return sfaWorkTaskReceveRespVo
     */
    @Override
    public SfaWorkTaskReleaseRespVo queryForUserReceve(String receveId) {
        AssertUtils.isNotEmpty(receveId, "入参ID不能为空");
        SfaWorkTaskReceveRespVo byReceveId = this.sfaWorkTaskReceveMapper.findOneByReceveId(receveId);
        if (Objects.isNull(byReceveId)) {
            return new SfaWorkTaskReleaseRespVo();
        }
        SfaWorkTaskReleaseRespVo one = this.sfaWorkTaskReleaseMapper.findOne(byReceveId.getTaskId());
        if (Objects.isNull(one)) {
            return new SfaWorkTaskReleaseRespVo();
        }
        byReceveId.setContent(one.getContent());
        this.buildReleasePics(one);
        //执行对象
        SfaWorkTaskObjectReqVo objectReqVo = new SfaWorkTaskObjectReqVo();
        objectReqVo.setTaskId(byReceveId.getTaskId());
        PageResult<SfaWorkTaskObjectRespVo> list = sfaWorkTaskObjectService.findList(objectReqVo);
        if (!ObjectUtils.isEmpty(list)){
            String taskObjectsStr = list.getData().stream().map(SfaWorkTaskObjectRespVo::getCustomerName).collect(Collectors.joining(";"));
            one.setTaskObjectsStr(taskObjectsStr);
        }
        List<SfaWorkTaskReceveRespVo> vos = new ArrayList<>(1);
        vos.add(byReceveId);
        one.setReceveRespVos(vos);
        //各个执行人的执行数据
        return this.buildTaskReceve(one, vos);
    }
    /**
     * 查询
     *
     * @param taskId
     * @return sfaWorkTaskReleaseRespVo
     */
    @Override
    public SfaWorkTaskReleaseRespVo query(String taskId) {
        AssertUtils.isNotEmpty(taskId, "入参不能为空");
        SfaWorkTaskReleaseRespVo one = this.sfaWorkTaskReleaseMapper.findOne(taskId);
        if (Objects.isNull(one)) {
            return new SfaWorkTaskReleaseRespVo();
        }
        this.buildReleasePics(one);
        //执行对象
        SfaWorkTaskObjectReqVo objectReqVo = new SfaWorkTaskObjectReqVo();
        objectReqVo.setTaskId(one.getTaskId());
        PageResult<SfaWorkTaskObjectRespVo> list = sfaWorkTaskObjectService.findList(objectReqVo);
        if (!ObjectUtils.isEmpty(list)){
            String taskObjectsStr = list.getData().stream().map(SfaWorkTaskObjectRespVo::getCustomerName).collect(Collectors.joining(";"));
            one.setTaskObjectsStr(taskObjectsStr);
        }

        List<SfaWorkTaskReceveRespVo> listByTaskId = this.sfaWorkTaskReceveMapper.findListByTaskId(taskId);
        if(CollectionUtil.listEmpty(listByTaskId)){
            return new SfaWorkTaskReleaseRespVo();
        }

//        //单个执行人直接返回
//        if(listByTaskId.size()==1){
//            // todo 图片
//            SfaWorkTaskReceveRespVo receveRespVo = listByTaskId.get(0);
//            one.setReceveRespVos(listByTaskId);
//            one.setSumAll(""+listByTaskId.size());
//            one.setExecutor(receveRespVo.getReceverName());
//            //执行附件
//            List<SfaWorkTaskPictureRespVo> taskExecutePic = SfaAttachmentUtil.getList(AttachmentBizTypeEnum.TASK_EXECUTE, receveRespVo.getId()).stream().map(v -> {
//                SfaWorkTaskPictureRespVo temp = new SfaWorkTaskPictureRespVo();
//                temp.setPicUrl(v.getUrlPathPrefix());
//                temp.setPicPath(v.getUrlPath());
//                temp.setTitle(v.getFileName());
//                return temp;
//            }).collect(Collectors.toList());
//            receveRespVo.setPictures(taskExecutePic);
//            return one;
//        }


        //各个执行人的执行数据
        return this.buildTaskReceve(one, listByTaskId);

    }


    /**
     * 各个执行人的执行数据
     * @param one
     * @param listByTaskId
     * @return
     */
    protected SfaWorkTaskReleaseRespVo buildTaskReceve(SfaWorkTaskReleaseRespVo one, List<SfaWorkTaskReceveRespVo> listByTaskId){
        //多人执行人
        StringJoiner executor = new StringJoiner("、");
        //已执行
        List<SfaWorkTaskReceveRespVo> receveRespVos = new ArrayList<>();
        List<String> ids = Lists.newArrayList();
        //未执行
        List<SfaWorkTaskReceveRespVo> receveRespNoVos = new ArrayList<>();
        for (SfaWorkTaskReceveRespVo sfaWorkTaskReceveRespVo : listByTaskId) {
            if(SfaTaskStatusEnum.EXECUTE_LODING.getCode().equals(sfaWorkTaskReceveRespVo.getExecuteStatus()) ||
                    SfaTaskStatusEnum.ALREADY_FINISH.getCode().equals(sfaWorkTaskReceveRespVo.getExecuteStatus())){
                receveRespVos.add(sfaWorkTaskReceveRespVo);
                ids.add(sfaWorkTaskReceveRespVo.getReceveId());
            }
            if(SfaTaskStatusEnum.WAIT_EXECUTE.getCode().equals(sfaWorkTaskReceveRespVo.getExecuteStatus()) ||
                    SfaTaskStatusEnum.PAST_DUE.getCode().equals(sfaWorkTaskReceveRespVo.getExecuteStatus())){
                receveRespNoVos.add(sfaWorkTaskReceveRespVo);
            }
            executor.add(sfaWorkTaskReceveRespVo.getReceverName());
        }
        //各个执行人执行时的附件
        Map<String, List<SfaAttachmentEntity>> pics = SfaAttachmentUtil.getList(AttachmentBizTypeEnum.TASK_EXECUTE, ids).stream().collect(Collectors.groupingBy(SfaAttachmentEntity :: getBizId));
        receveRespVos.forEach(v -> {
            List<SfaAttachmentEntity> temps = pics.get(v.getReceveId());
            if(null == temps){
                temps = Lists.newArrayList();
            }
            v.setPictures(temps.stream().map(pic -> {
                SfaWorkTaskPictureRespVo temp = new SfaWorkTaskPictureRespVo();
                temp.setPicUrl(pic.getUrlPathPrefix());
                temp.setPicPath(pic.getUrlPath());
                temp.setTitle(pic.getFileName());
                return temp;
            }).collect(Collectors.toList()));
        });
        //汇总到任务
        one.setExecutor(executor.toString());
        one.setReceveRespVos(receveRespVos);
        one.setReceveRespNoVos(receveRespNoVos);
        one.setSumAll("" + listByTaskId.size());
        return one;
    }

    /**
     * 工作任务新增
     *
     * @param reqVo
     * @return
     */
    @Override
    public void save(SfaWorkTaskReleaseReqVo reqVo) {
        //参数校验
        this.checkSfaWorkReleaseReqVo(reqVo);
        SfaWorkTaskReleaseEntity entity = CrmBeanUtil.copy(reqVo, SfaWorkTaskReleaseEntity.class);
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        //写入默认值
        // 0待执行 1部分完成 2已完成 3未完成 4已拒绝 5已过期
        entity.setTaskStatus(SfaTaskReleaseEnum.WAIT_EXECUTE.getCode());

        List<SfaStaffMessageReqVo> reqVos = reqVo.getSfaStaffMessageReqVos();
        //进度比例
        entity.setProgress("0/" + (CollectionUtil.listNotEmptyNotSizeZero(reqVos) ?reqVos.size():"0"));
        //写入任务编码
        entity.setTaskCode(CodeUtil.generateCode(CodeRuleEnum.SFA_TASK_CODE.getCode()));
        this.sfaWorkTaskReleaseMapper.insert(entity);
        //拿到id
        String id = entity.getId();

        Iterator<SfaStaffMessageReqVo> iterator = reqVos.iterator();
        List<SfaWorkTaskReceveEntity> sfList = new ArrayList<>();
        while (iterator.hasNext()) {
            SfaStaffMessageReqVo next = iterator.next();
            SfaWorkTaskReceveEntity entityReceve = CrmBeanUtil.copy(next, SfaWorkTaskReceveEntity.class);
            entityReceve.setReceveDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            entityReceve.setExecuteStatus(SfaTaskStatusEnum.WAIT_EXECUTE.getCode());
            entityReceve.setTaskId(id);
            sfList.add(entityReceve);
        }
        //分片插入
        List<List<SfaWorkTaskReceveEntity>> partition = Lists.partition(sfList, 50);
        for (List<SfaWorkTaskReceveEntity> sfaWorkTaskReceveEntities : partition) {
            sfaWorkTaskReceveService.saveBatch(sfaWorkTaskReceveEntities);
        }

        //新增图片
        List<SfaWorkTaskPictureReqVo> pictures = reqVo.getPictures();

        SfaAttachmentUtil.insert(CrmAttachment.convertTaskPic(pictures), AttachmentBizTypeEnum.TASK_ADD, id);

        //新增执行对象
        List<SfaWorkTaskObjectReqVo> taskObjects = reqVo.getTaskObjects();
        if (CollectionUtil.listNotEmpty(taskObjects)){
            taskObjects.forEach(o -> {
                o.setId(null);
                o.setTaskId(id);
            });
            sfaWorkTaskObjectService.save(taskObjects);
        }
    }

    /**
     * 新增/编辑参数验证
     *
     * @param reqVo
     */
    private void checkSfaWorkReleaseReqVo(SfaWorkTaskReleaseReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getTaskTitle(), "请输入任务名称");
        AssertUtils.isNotEmpty(reqVo.getContent(), "请输入任务详情");
        AssertUtils.isNotEmpty(reqVo.getEndDate(), "请输入任务结束时间");
        //检查任务执行人参数
       this.checkSfaStaffMessageReqVo(reqVo);
        LocalDateTime startDate = LocalDateTime.now();
        AssertUtils.isNotEmpty(reqVo.getEndDate(), "结束时间不能为空");
        LocalDateTime endDate = null;
        try {
            endDate = CrmDateUtils.parseyyyyMMddHHmmss(reqVo.getEndDate() + " 23:59:59");
        } catch (Exception e) {
            throw new BusinessException("结束时间格式错误");
        }
        if (!(startDate.isBefore(endDate))) {
            throw new BusinessException("结束时间不能小于当前时间");
        }
    }

    /**
     * 检查任务执行人参数
     * @param reqVo
     */
    private void checkSfaStaffMessageReqVo(SfaWorkTaskReleaseReqVo reqVo){
        List<SfaStaffMessageReqVo> sfaStaffMessageReqVos = reqVo.getSfaStaffMessageReqVos();
        if(CollectionUtils.isEmpty(sfaStaffMessageReqVos)){
            AssertUtils.isNotEmpty("","请指定任务执行人");
        }
        List<String> orgCodes = sfaStaffMessageReqVos.stream().filter(v -> StringUtils.isNotBlank(v.getReceverOrgCode()))
                .map(SfaStaffMessageReqVo :: getReceverOrgCode).collect(Collectors.toList());
        List<String> posCodes = sfaStaffMessageReqVos.stream().filter(v -> StringUtils.isNotBlank(v.getReceverPosCode()))
                .map(SfaStaffMessageReqVo :: getReceverPosCode).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(orgCodes)){
            throw new BusinessException("任务执行人组织不能为空");
        }
        if(CollectionUtils.isEmpty(posCodes)){
            throw new BusinessException("任务执行人职位不能为空");
        }
        Map<String, MdmOrgRespVo> orgRespVoMap = OrgUtil.getOrgByCodeList(orgCodes).stream().collect(Collectors.toMap(MdmOrgRespVo :: getOrgCode, v -> v, (t, t2) -> t2));
        Map<String, MdmPositionRespVo> positionRespVoMap = PositionUtil.getPositionByCodeList(posCodes).stream().collect(Collectors.toMap(MdmPositionRespVo :: getPositionCode, v -> v, (t, t2) -> t2));
        for (SfaStaffMessageReqVo sfaStaffMessageReqVo : sfaStaffMessageReqVos) {
            if(StringUtils.isBlank(sfaStaffMessageReqVo.getReceverCode())){
                throw new BusinessException("任务执行人账号不能为空");
            }
            String receverOrgCode = sfaStaffMessageReqVo.getReceverOrgCode();
            if(StringUtils.isBlank(receverOrgCode)){
                throw new BusinessException("任务执行人组织不能为空");
            }
            MdmOrgRespVo mdmOrgRespVo = orgRespVoMap.get(receverOrgCode);
            if(null == mdmOrgRespVo){
                throw new BusinessException("不存在的任务执行人组织[" + receverOrgCode + "]");
            }
            sfaStaffMessageReqVo.setReceverOrgName(mdmOrgRespVo.getOrgName());

            String receverPosCode = sfaStaffMessageReqVo.getReceverPosCode();
            if(StringUtils.isBlank(receverPosCode)){
                throw new BusinessException("任务执行人职位不能为空");
            }
            MdmPositionRespVo mdmPositionRespVo = positionRespVoMap.get(receverPosCode);
            if(null == mdmPositionRespVo){
                throw new BusinessException("不存在的任务执行人职位[" + receverPosCode + "]");
            }
            sfaStaffMessageReqVo.setReceverPosName(mdmPositionRespVo.getPositionName());
        }
    }

    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    @Override
    public void update(SfaWorkTaskReleaseReqVo reqVo) {
        SfaWorkTaskReceveEntity entityReceve = CrmBeanUtil.copy(reqVo, SfaWorkTaskReceveEntity.class);
        int i = this.sfaWorkTaskReceveMapper.updateById(entityReceve);

    }

    /**
     * 定时任务
     * @param thisTime 当前时间yyyyMMdd
     */
    @Override
    public void timeExpiredTask(String thisTime) {

        //查询所有符合条件的数据
        List<SfaTaskTimeExpiredRespVo> expiredByTime = this.sfaWorkTaskReceveMapper.findTimeExpiredByTime(thisTime, SfaTaskStatusEnum.WAIT_EXECUTE.getCode());
        if (expiredByTime != null && expiredByTime.size() > 0) {
            Iterator<SfaTaskTimeExpiredRespVo> iterator = expiredByTime.iterator();
            while (iterator.hasNext()) {
                SfaTaskTimeExpiredRespVo next = iterator.next();
                SfaWorkTaskReceveReqVo reqVo = this.timeExpRespToreceveReq(next);
                reqVo.setExecuteStatus(SfaTaskStatusEnum.PAST_DUE.getCode());
                //设置为过期
                sfaWorkTaskReceveService.update(reqVo);
            }
        }
    }


    /**
     * 转换
     * @param sfaTaskTimeExpiredRespVo
     * @return
     */
    private SfaWorkTaskReceveReqVo timeExpRespToreceveReq(SfaTaskTimeExpiredRespVo sfaTaskTimeExpiredRespVo) {
        SfaWorkTaskReceveReqVo reqVo = new SfaWorkTaskReceveReqVo();
        reqVo.setReceveId(sfaTaskTimeExpiredRespVo.getReceveId());
        reqVo.setAddress(sfaTaskTimeExpiredRespVo.getAddress());
        reqVo.setSummary(sfaTaskTimeExpiredRespVo.getSummary());
        reqVo.setExecuteStatus(sfaTaskTimeExpiredRespVo.getExecuteStatus());
        return reqVo;

    }

    /**
     * 计算百分比
     *
     * @param molecule    分子
     * @param denominator 分母
     * @return
     */
    private String getPercentage(Integer molecule, Integer denominator) {

        // 创建一个数值格式化对象
        NumberFormat numberFormat = NumberFormat.getInstance();
        // 设置精确到小数点后2位
        numberFormat.setMaximumFractionDigits(2);
        return numberFormat.format((float) molecule / (float) denominator * 100);

    }


}
