package com.biz.crm.audit.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.audit.service.ISfaAuditAttendanceService;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditAttendanceRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditAttendanceReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 考勤稽查表
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Slf4j
@RestController
@RequestMapping("/sfaauditattendance")
@Api(tags = "考勤稽查结果")
public class SfaAuditAttendanceController {
    @Autowired
    private ISfaAuditAttendanceService sfaAuditAttendanceService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaAuditAttendanceRespVo>> list(@RequestBody SfaAuditAttendanceReqVo sfaAuditAttendanceReqVo) {
        PageResult<SfaAuditAttendanceRespVo> result=sfaAuditAttendanceService.findList(sfaAuditAttendanceReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaAuditAttendanceRespVo> query(@RequestBody SfaAuditAttendanceReqVo sfaAuditAttendanceReqVo) {
        SfaAuditAttendanceRespVo respVo=sfaAuditAttendanceService.query(sfaAuditAttendanceReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaAuditAttendanceReqVo sfaAuditAttendanceReqVo) {
        sfaAuditAttendanceService.save(sfaAuditAttendanceReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaAuditAttendanceReqVo sfaAuditAttendanceReqVo) {
        sfaAuditAttendanceService.update(sfaAuditAttendanceReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaAuditAttendanceReqVo sfaAuditAttendanceReqVo) {
        sfaAuditAttendanceService.deleteBatch(sfaAuditAttendanceReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaAuditAttendanceReqVo sfaAuditAttendanceReqVo) {
        sfaAuditAttendanceService.enableBatch(sfaAuditAttendanceReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaAuditAttendanceReqVo sfaAuditAttendanceReqVo) {
        sfaAuditAttendanceService.disableBatch(sfaAuditAttendanceReqVo);
        return Result.ok("禁用成功");
    }
}
