package com.biz.crm.audit.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.audit.service.ISfaAuditInspectorsService;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditInspectorsRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditInspectorsReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 稽查人员区域配置表
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Slf4j
@RestController
@RequestMapping("/sfaauditinspectors")
@Api(tags = "稽查人员区域配置")
public class SfaAuditInspectorsController {
    @Autowired
    private ISfaAuditInspectorsService sfaAuditInspectorsService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaAuditInspectorsRespVo>> list(@RequestBody SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo) {
        PageResult<SfaAuditInspectorsRespVo> result=sfaAuditInspectorsService.findList(sfaAuditInspectorsReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaAuditInspectorsRespVo> query(@RequestBody SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo) {
        SfaAuditInspectorsRespVo respVo=sfaAuditInspectorsService.query(sfaAuditInspectorsReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo) {
        sfaAuditInspectorsService.save(sfaAuditInspectorsReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo) {
        sfaAuditInspectorsService.update(sfaAuditInspectorsReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo) {
        sfaAuditInspectorsService.deleteBatch(sfaAuditInspectorsReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo) {
        sfaAuditInspectorsService.enableBatch(sfaAuditInspectorsReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo) {
        sfaAuditInspectorsService.disableBatch(sfaAuditInspectorsReqVo);
        return Result.ok("禁用成功");
    }


}
