package com.biz.crm.audit.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.audit.service.ISfaAuditProductPriceService;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditProductPriceRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditProductPriceReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.aop.CrmLog;

import java.util.List;

/**
 * 产品价格稽查主表
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Slf4j
@RestController
@RequestMapping("/sfaauditprouditprice")
@Api(tags = "产品价格稽查结果")
public class SfaAuditProductPriceController {
    @Autowired
    private ISfaAuditProductPriceService sfaAuditProuditPriceService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaAuditProductPriceRespVo>> list(@RequestBody SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo) {
        PageResult<SfaAuditProductPriceRespVo> result=sfaAuditProuditPriceService.findList(sfaAuditProductPriceReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaAuditProductPriceRespVo> query(@RequestBody SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo) {
        SfaAuditProductPriceRespVo respVo=sfaAuditProuditPriceService.query(sfaAuditProductPriceReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo) {
        sfaAuditProuditPriceService.save(sfaAuditProductPriceReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo) {
        sfaAuditProuditPriceService.update(sfaAuditProductPriceReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo) {
        sfaAuditProuditPriceService.deleteBatch(sfaAuditProductPriceReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo) {
        sfaAuditProuditPriceService.enableBatch(sfaAuditProductPriceReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo) {
        sfaAuditProuditPriceService.disableBatch(sfaAuditProductPriceReqVo);
        return Result.ok("禁用成功");
    }

    /**
     * 根据终端编码查询产品稽查记录
     */
    @ApiOperation(value = "终端-查询终端下的产品价格稽查记录")
    @PostMapping("/queryProductAudit")
    @CrmLog
    public Result queryProductAudit(@RequestBody SfaAuditProductPriceReqVo reqVo){
        List<SfaAuditProductPriceRespVo> respVos = sfaAuditProuditPriceService.queryProductAudit(reqVo);
        return Result.ok(respVos);
    }

    /**
     * 根据稽查编码查询稽查记录详情
     */
    @ApiOperation(value = "终端-查询稽查记录详情信息")
    @PostMapping("/queryProductAuditDetail")
    @CrmLog
    public Result queryProductAuditDetail(@RequestBody SfaAuditProductPriceReqVo reqVo){
        SfaAuditProductPriceRespVo respVos=sfaAuditProuditPriceService.queryProductAuditDetail(reqVo);
        return Result.ok(respVos);
    }

}
