package com.biz.crm.audit.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.audit.service.ISfaAuditProductPriceProService;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditProductPriceProRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditProductPriceProReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 产品价格稽查-产品表
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Slf4j
@RestController
@RequestMapping("/sfaauditproductpricepro")
@Api(tags = "产品价格稽查-产品")
public class SfaAuditProductPriceProController {
    @Autowired
    private ISfaAuditProductPriceProService sfaAuditProductPriceProService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaAuditProductPriceProRespVo>> list(@RequestBody SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo) {
        PageResult<SfaAuditProductPriceProRespVo> result=sfaAuditProductPriceProService.findList(sfaAuditProductPriceProReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaAuditProductPriceProRespVo> query(@RequestBody SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo) {
        SfaAuditProductPriceProRespVo respVo=sfaAuditProductPriceProService.query(sfaAuditProductPriceProReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo) {
        sfaAuditProductPriceProService.save(sfaAuditProductPriceProReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo) {
        sfaAuditProductPriceProService.update(sfaAuditProductPriceProReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo) {
        sfaAuditProductPriceProService.deleteBatch(sfaAuditProductPriceProReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo) {
        sfaAuditProductPriceProService.enableBatch(sfaAuditProductPriceProReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo) {
        sfaAuditProductPriceProService.disableBatch(sfaAuditProductPriceProReqVo);
        return Result.ok("禁用成功");
    }
}
