package com.biz.crm.audit.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.audit.service.ISfaAuditTerminalCommonService;
import com.biz.crm.nebular.mdm.product.req.MdmProductBySfaReqVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductBySfaRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.sfa.audit.req.SfaTPMTerminalReqVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@Slf4j
@RestController
@RequestMapping("/sfaAuditCommon")
@Api(tags = "终端-获得人员配置区域终端信息")
public class SfaAuditTerminalCommonController {

    @Resource
    private ISfaAuditTerminalCommonService iSfaAuditTerminalCommonService;

    /**
     * 查看登录人员配置的区域终端信息
     */
    @ApiOperation(value = "终端-查看登录人员配置的区域终端信息")
    @PostMapping("/queryTPMInfo")
    @CrmLog
    public Result queryTPMInfo(@RequestBody SfaTPMTerminalReqVo reqVo){
        List<MdmTerminalVo> mdmTerminalVos = iSfaAuditTerminalCommonService.queryTpmInfo(reqVo);
        return Result.ok(mdmTerminalVos);
    }

    /**
     * 查看所有商品信息
     */
    @ApiOperation(value = "终端-查看所有的商品信息")
    @PostMapping("/queryAllProductInfo")
    @CrmLog
    public Result queryAllProductInfo(@RequestBody MdmProductBySfaReqVo reqVo){
        List<MdmProductBySfaRespVo> respVos = iSfaAuditTerminalCommonService.queryAllProduct(reqVo);
        return Result.ok(respVos);
    }



}
