package com.biz.crm.audit.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.audit.service.ISfaAuditTerminalRealService;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTerminalRealRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditTerminalRealReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.List;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 终端真实性稽查表
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Slf4j
@RestController
@RequestMapping("/sfaauditterminalreal")
@Api(tags = "终端真实性稽查结果")
public class SfaAuditTerminalRealController {
    @Autowired
    private ISfaAuditTerminalRealService sfaAuditTerminalRealService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaAuditTerminalRealRespVo>> list(@RequestBody SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo) {
        PageResult<SfaAuditTerminalRealRespVo> result=sfaAuditTerminalRealService.findList(sfaAuditTerminalRealReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaAuditTerminalRealRespVo> query(@RequestBody SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo) {
        SfaAuditTerminalRealRespVo respVo=sfaAuditTerminalRealService.query(sfaAuditTerminalRealReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo) {
        sfaAuditTerminalRealService.save(sfaAuditTerminalRealReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo) {
        sfaAuditTerminalRealService.update(sfaAuditTerminalRealReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo) {
        sfaAuditTerminalRealService.deleteBatch(sfaAuditTerminalRealReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo) {
        sfaAuditTerminalRealService.enableBatch(sfaAuditTerminalRealReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo) {
        sfaAuditTerminalRealService.disableBatch(sfaAuditTerminalRealReqVo);
        return Result.ok("禁用成功");
    }

    /**
     * 根据终端编码查看稽查记录
     */
    @ApiOperation(value = "终端-查看终端真实性稽查记录")
    @PostMapping("/queryTerminalAudit")
    @CrmLog
    public Result queryTerminalAudit(@RequestBody SfaAuditTerminalRealReqVo reqVo){
        List<SfaAuditTerminalRealRespVo> respVos = sfaAuditTerminalRealService.queryTerminalAudit(reqVo);
        return Result.ok(respVos);
    }

    /**
     * 根据稽查编码查询稽查记录详情
     */
    @ApiOperation(value = "终端-查看终端真实性稽查记录详情")
    @PostMapping("/queryTerminalAuditDetail")
    @CrmLog
    public Result queryTerminalAuditDetail(@RequestBody SfaAuditTerminalRealReqVo reqVo){
        SfaAuditTerminalRealRespVo respVos = sfaAuditTerminalRealService.queryTerminalAuditDetail(reqVo);
        return Result.ok(respVos);
    }
}
