package com.biz.crm.audit.controller;

import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditInspectorsReqVo;
import com.biz.crm.nebular.sfa.audit.req.SfaTPMTerminalReqVo;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTpmActInfoRespVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActReqVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.audit.service.ISfaAuditTpmService;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTpmRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditTpmReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.List;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * TPM稽查表
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Slf4j
@RestController
@RequestMapping("/sfaaudittpm")
@Api(tags = "TPM稽查结果")
public class SfaAuditTpmController {
    @Autowired
    private ISfaAuditTpmService sfaAuditTpmService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaAuditTpmRespVo>> list(@RequestBody SfaAuditTpmReqVo sfaAuditTpmReqVo) {
        PageResult<SfaAuditTpmRespVo> result=sfaAuditTpmService.findList(sfaAuditTpmReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaAuditTpmRespVo> query(@RequestBody SfaAuditTpmReqVo sfaAuditTpmReqVo) {
        SfaAuditTpmRespVo respVo=sfaAuditTpmService.query(sfaAuditTpmReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaAuditTpmReqVo sfaAuditTpmReqVo) {
        sfaAuditTpmService.save(sfaAuditTpmReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaAuditTpmReqVo sfaAuditTpmReqVo) {
        sfaAuditTpmService.update(sfaAuditTpmReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaAuditTpmReqVo sfaAuditTpmReqVo) {
        sfaAuditTpmService.deleteBatch(sfaAuditTpmReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaAuditTpmReqVo sfaAuditTpmReqVo) {
        sfaAuditTpmService.enableBatch(sfaAuditTpmReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaAuditTpmReqVo sfaAuditTpmReqVo) {
        sfaAuditTpmService.disableBatch(sfaAuditTpmReqVo);
        return Result.ok("禁用成功");
    }

    /**
     * 查看TPM稽查终端信息
     */
    @ApiOperation(value = "终端-查看TPM稽查终端信息")
    @PostMapping("/queryTPMInfo")
    @CrmLog
    public Result queryTPMInfo(@RequestBody SfaTPMTerminalReqVo reqVo){
        List<MdmTerminalVo> mdmTerminalVos = sfaAuditTpmService.queryTpmInfo(reqVo);
        return Result.ok(mdmTerminalVos);
    }

    /**
     * 根据终端编码查看稽查记录
     */
    @ApiOperation(value = "终端-查看TPM终端稽查记录")
    @PostMapping("/queryByTerminalCode")
    @CrmLog
    public Result queryByTerminalCode(@RequestBody SfaAuditTpmReqVo reqVo){
        List<SfaAuditTpmRespVo> sfaAuditTpmRespVos = sfaAuditTpmService.queryTpmByTerminalCode(reqVo);
        return Result.ok(sfaAuditTpmRespVos);
    }

    /**
     * 查看终端下的TPM已稽查活动信息
     */
    @ApiOperation(value = "终端-查看已稽查TPM活动信息")
    @PostMapping("/queryTpmAuditAct")
    @CrmLog
    public Result queryTpmAuditAct(@RequestBody SfaTpmActReqVo reqVo){
        List<SfaTpmActRespVo> sfaTpmActRespVos=sfaAuditTpmService.queryTpmAuditAct(reqVo);
        return  Result.ok(sfaTpmActRespVos);
    }

    /**
     * 查看终端下的TPM待稽查活动信息
     */
    @ApiOperation(value = "终端-查看待稽查TPM活动信息")
    @PostMapping("/queryTpmToAuditAct")
    @CrmLog
    public Result queryTpmToAuditAct(@RequestBody SfaTpmActReqVo reqVo){
        List<SfaTpmActRespVo> sfaTpmActRespVos=sfaAuditTpmService.queryTpmToAuditAct(reqVo);
        return  Result.ok(sfaTpmActRespVos);
    }

    /**
     * 查看TPM稽查活动详情信息
     */
    @ApiOperation(value = "终端-查看TPM活动详情")
    @PostMapping("/queryTpmActDetail")
    @CrmLog
    public Result queryTpmActDetail(@RequestBody SfaAuditTpmReqVo reqVo){
       List<SfaAuditTpmActInfoRespVo> respList=sfaAuditTpmService.queryTpmActDetail(reqVo);
       return Result.ok(respList);
    }

    /**
     * 查看TPM费用活动稽查明细
     */
    @ApiOperation(value = "查看TPM费用活动稽查明细")
    @PostMapping("/queryTpmActAuditDetail")
    @CrmLog
    public Result queryTpmActAuditDetail(@RequestBody SfaAuditTpmReqVo reqVo){
        List<SfaAuditTpmActInfoRespVo> respVos=sfaAuditTpmService.queryTpmActAuditDetail(reqVo);
        return Result.ok(respVos);
    }
}
