package com.biz.crm.audit.controller;

import com.biz.crm.nebular.sfa.audit.req.SfaAuditTerminalRealReqVo;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTerminalRealRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.audit.service.ISfaAuditTransregionalService;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTransregionalRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditTransregionalReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.List;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 窜货稽查表
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Slf4j
@RestController
@RequestMapping("/sfaaudittransregional")
@Api(tags = "窜货稽查结果")
public class SfaAuditTransregionalController {
    @Autowired
    private ISfaAuditTransregionalService sfaAuditTransregionalService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaAuditTransregionalRespVo>> list(@RequestBody SfaAuditTransregionalReqVo sfaAuditTransregionalReqVo) {
        PageResult<SfaAuditTransregionalRespVo> result=sfaAuditTransregionalService.findList(sfaAuditTransregionalReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaAuditTransregionalRespVo> query(@RequestBody SfaAuditTransregionalReqVo sfaAuditTransregionalReqVo) {
        SfaAuditTransregionalRespVo respVo=sfaAuditTransregionalService.query(sfaAuditTransregionalReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaAuditTransregionalReqVo sfaAuditTransregionalReqVo) {
        sfaAuditTransregionalService.save(sfaAuditTransregionalReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaAuditTransregionalReqVo sfaAuditTransregionalReqVo) {
        sfaAuditTransregionalService.update(sfaAuditTransregionalReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaAuditTransregionalReqVo sfaAuditTransregionalReqVo) {
        sfaAuditTransregionalService.deleteBatch(sfaAuditTransregionalReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaAuditTransregionalReqVo sfaAuditTransregionalReqVo) {
        sfaAuditTransregionalService.enableBatch(sfaAuditTransregionalReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaAuditTransregionalReqVo sfaAuditTransregionalReqVo) {
        sfaAuditTransregionalService.disableBatch(sfaAuditTransregionalReqVo);
        return Result.ok("禁用成功");
    }

    /**
     * 根据终端编码查看稽查记录
     */
    @ApiOperation(value = "终端-查看终端窜货稽查记录")
    @PostMapping("/queryTransregionalAudit")
    @CrmLog
    public Result queryTransregionalAudit(@RequestBody SfaAuditTransregionalReqVo reqVo){
        List<SfaAuditTransregionalRespVo> respVos = sfaAuditTransregionalService.queryTransregionalAudit(reqVo);
        return Result.ok(respVos);
    }

    /**
     * 根据稽查编码查询稽查记录详情
     */
    @ApiOperation(value = "终端-查看终端窜货稽查记录详情")
    @PostMapping("/queryTransregionalAuditDetail")
    @CrmLog
    public Result queryTransregionalAuditDetail(@RequestBody SfaAuditTransregionalReqVo reqVo){
        SfaAuditTransregionalRespVo respVos = sfaAuditTransregionalService.queryTransregionalAuditDetail(reqVo);
        return Result.ok(respVos);
    }
}
