package com.biz.crm.audit.mapper;

import com.biz.crm.audit.model.SfaAuditInspectorsEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.apache.ibatis.annotations.Mapper;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditInspectorsRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditInspectorsReqVo;
import java.util.List;
import java.util.Map;

/**
 * 稽查人员区域配置表
 * 
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
public interface SfaAuditInspectorsMapper extends BaseMapper<SfaAuditInspectorsEntity> {
    /**
     * 列表
     * @param page
     * @param sfaAuditInspectorsReqVo
     * @return
     */
    List<SfaAuditInspectorsRespVo> findList(Page<SfaAuditInspectorsRespVo> page, @Param("vo") SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo);

    /**
     * 根据登录账号获得配置信息
     * @param auditAccount
     * @return
     */
    SfaAuditInspectorsEntity queryInfoByAccount(@Param("auditAccount") String auditAccount);
}
