package com.biz.crm.audit.mapper;

import com.biz.crm.audit.model.SfaAuditProductPriceEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditProductPriceRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditProductPriceReqVo;
import java.util.List;

/**
 * 产品价格稽查主表
 * 
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
public interface SfaAuditProductPriceMapper extends BaseMapper<SfaAuditProductPriceEntity> {
    /**
     * 列表
     * @param page
     * @param sfaAuditProductPriceReqVo
     * @return
     */
    List<SfaAuditProductPriceRespVo> findList(Page<SfaAuditProductPriceRespVo> page, @Param("vo") SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo);

    /**
     * 根据终端编码和稽查结果查询列表
     */
    List<SfaAuditProductPriceRespVo> queryByTerminalCode(@Param("vo") SfaAuditProductPriceReqVo vo);

    /**
     * 根据稽查编码查询稽查记录详情
     */
    SfaAuditProductPriceRespVo queryAuditDetailByCode(@Param("vo") SfaAuditProductPriceReqVo vo);
}
