package com.biz.crm.audit.mapper;

import com.biz.crm.audit.model.SfaAuditProductPriceProEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.apache.ibatis.annotations.Mapper;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditProductPriceProRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditProductPriceProReqVo;
import java.util.List;
import java.util.Map;

/**
 * 产品价格稽查-产品表
 * 
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
public interface SfaAuditProductPriceProMapper extends BaseMapper<SfaAuditProductPriceProEntity> {
    /**
     * 列表
     * @param page
     * @param sfaAuditProductPriceProReqVo
     * @return
     */
    List<SfaAuditProductPriceProRespVo> findList(Page<SfaAuditProductPriceProRespVo> page, @Param("vo") SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo);

    /**
     * 根据稽查主表id查询稽查产品列表
     */
    List<SfaAuditProductPriceProRespVo> findListByProductId(@Param("code") String code);
}
