package com.biz.crm.audit.mapper;

import com.biz.crm.audit.model.SfaAuditTerminalRealEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.apache.ibatis.annotations.Mapper;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTerminalRealRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditTerminalRealReqVo;
import java.util.List;
import java.util.Map;

/**
 * 终端真实性稽查表
 * 
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
public interface SfaAuditTerminalRealMapper extends BaseMapper<SfaAuditTerminalRealEntity> {
    /**
     * 列表
     * @param page
     * @param sfaAuditTerminalRealReqVo
     * @return
     */
    List<SfaAuditTerminalRealRespVo> findList(Page<SfaAuditTerminalRealRespVo> page, @Param("vo") SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo);

    /**
     * 根据终端编码查看稽查记录详情
     */
    List<SfaAuditTerminalRealRespVo> queryAuditByTerminalCode(@Param("vo") SfaAuditTerminalRealReqVo reqVo);

    /**
     * 根据终端编码查看稽查记录详情
     */
    SfaAuditTerminalRealRespVo queryAuditByAuditCode(@Param("vo") SfaAuditTerminalRealReqVo reqVo);


}
