package com.biz.crm.audit.mapper;

import com.biz.crm.audit.model.SfaAuditTpmEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.apache.ibatis.annotations.Mapper;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTpmRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditTpmReqVo;
import java.util.List;
import java.util.Map;

/**
 * TPM稽查表
 * 
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
public interface SfaAuditTpmMapper extends BaseMapper<SfaAuditTpmEntity> {
    /**
     * 列表
     * @param page
     * @param sfaAuditTpmReqVo
     * @return
     */
    List<SfaAuditTpmRespVo> findList(Page<SfaAuditTpmRespVo> page, @Param("vo") SfaAuditTpmReqVo sfaAuditTpmReqVo);

    /**
     * 根据终端编码查询TPM稽查记录
     */
    List<SfaAuditTpmRespVo> queryTpmByTerminal(@Param("vo") SfaAuditTpmReqVo vo);

    /**
     * 根据终端编码获得活动编码
     */
    List<SfaAuditTpmRespVo> queryActCodeByTerminal(@Param("vo") String vo);

    /**
     * 根据终端编码和活动编码获得稽查信息
     */
    List<SfaAuditTpmRespVo> queryAuditByCodes(@Param("req") SfaAuditTpmReqVo req);
}
