package com.biz.crm.audit.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import com.biz.crm.base.CrmBaseEntity;

import java.util.Date;

import lombok.experimental.Accessors;

/**
 * 稽查人员区域配置表实体类
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_audit_inspectors")
@CrmTable(name = "sfa_audit_inspectors", tableNote = "稽查人员区域配置表")
public class SfaAuditInspectorsEntity extends CrmExtTenEntity<SfaAuditInspectorsEntity> {


    /**
     * 登录账号
     */
    @CrmColumn(name = "audit_account", length = 32, note = "登录账号")
    private String auditAccount;


    /**
     * 稽查人员姓名
     */
    @CrmColumn(name = "audit_name", length = 32, note = "稽查人员姓名")
    private String auditName;


    /**
     * 稽查人员职位
     */
    @CrmColumn(name = "audit_position", length = 40, note = "稽查人员职位")
    private String auditPosition;

    /**
     * 稽查区域编码
     */
    @CrmColumn(name="audit_area_code",length = 255,note = "稽查区域编码")
    private String auditAreaCode;

    /**
     * 稽查区域
     */
    @CrmColumn(name = "audit_area", length = 200, note = "稽查区域")
    private String auditArea;


    /**
     * 生效状态
     */
    @CrmColumn(name = "effective_state", length = 10, note = "生效状态")
    private String effectiveState;


    /**
     * 生效时间
     */
    @CrmColumn(name = "effective_date", length = 32, note = "生效时间")
    private String effectiveDate;


    /**
     * 失效时间
     */
    @CrmColumn(name = "failure_date", length = 32, note = "失效时间")
    private String failureDate;

}
