package com.biz.crm.audit.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;

import lombok.experimental.Accessors;

/**
 * 产品价格稽查主表实体类
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_audit_proudit_price")
@CrmTable(name = "sfa_audit_proudit_price", tableNote = "产品价格稽查主表")
public class SfaAuditProductPriceEntity extends CrmExtTenEntity<SfaAuditProductPriceEntity> {


    /**
     * 稽查人员
     */
    @CrmColumn(name = "audit_inspector", length = 60, note = "稽查人员")
    private String auditInspector;

    /**
     * 稽查人员登录账号
     */
    @CrmColumn(name = "audit_account", length = 40, note = "登录账号")
    private String auditAccount;

    /**
     * 稽查编码
     */
    @CrmColumn(name = "audit_code", length = 32, note = "稽查编码")
    private String auditCode;


    /**
     * 区域
     */
    @CrmColumn(name = "audit_area", length = 200, note = "区域")
    private String auditArea;

    /**
     * 稽查区域编码
     */
    @CrmColumn(name="audit_area_code",length = 200,note = "稽查区域编码")
    private String auditAreaCode;


    /**
     * 稽查终端
     */
    @CrmColumn(name = "audit_terminal", length = 40, note = "稽查终端")
    private String auditTerminal;

    /**
     * 终端编码
     */
    @CrmColumn(name = "terminal_code", length = 32, note = "终端编码")
    private String terminalCode;


    /**
     * 稽查时间
     */
    @CrmColumn(name = "audit_date", length = 32, note = "稽查时间")
    private String auditDate;


    /**
     * 稽查结果
     */
    @CrmColumn(name = "audit_result", length = 10, note = "稽查结果")
    private Boolean auditResult;


    /**
     * 稽查产品数量
     */
    @CrmColumn(name = "audit_product_quantity", length = 200, note = "稽查产品数量")
    private Integer auditProductQuantity;


    /**
     * 不合格产品数
     */
    @CrmColumn(name = "unqualified_product_quantity", length = 200, note = "不合格产品数")
    private Integer unqualifiedProductQuantity;


    /**
     * 稽查结果描述
     */
    @CrmColumn(name = "audit_result_desc", length = 500, note = "稽查结果描述")
    private String auditResultDesc;


    /**
     * 稽查图片
     */
    @CrmColumn(name = "audit_picture", length = 200, note = "稽查图片")
    private String auditPicture;

}
