package com.biz.crm.audit.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import com.biz.crm.base.CrmBaseEntity;

import java.math.BigDecimal;
import java.util.Date;

import lombok.experimental.Accessors;

/**
 * 产品价格稽查-产品表实体类
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_audit_product_price_pro")
@CrmTable(name = "sfa_audit_product_price_pro", tableNote = "产品价格稽查-产品表")
public class SfaAuditProductPriceProEntity extends CrmExtTenEntity<SfaAuditProductPriceProEntity> {


    /**
     * 稽查编码
     */
    @CrmColumn(name = "audit_code", length = 40, note = "稽查编码")
    private String auditCode;


    /**
     * 产品编码
     */
    @CrmColumn(name = "product_code", length = 60, note = "产品编码")
    private String productCode;


    /**
     * 产品名称
     */
    @CrmColumn(name = "product_name", length = 32, note = "产品名称")
    private String productName;


    /**
     * 终端标准零售价
     */
    @CrmColumn(name = "terminal_standard_retail_price", mysqlType = "decimal(32,6)", oracleType = "NUMBER(32,6)", note = "终端标准零售价")
    private BigDecimal terminalStandardRetailPrice;


    /**
     * 终端实际零售价
     */
    @CrmColumn(name = "terminal_actual_retail_price", mysqlType = "decimal(32,6)", oracleType = "NUMBER(32,6)", note = "终端实际零售价")
    private BigDecimal terminalActualRetailPrice;


    /**
     * 销售标准是否达标
     */
    @CrmColumn(name = "sales_target", length = 10, note = "销售标准是否达标")
    private Boolean salesTarget;

}
