package com.biz.crm.audit.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import com.biz.crm.base.CrmBaseEntity;

import java.util.Date;

import lombok.experimental.Accessors;

/**
 * 窜货稽查表实体类
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_audit_transregional")
@CrmTable(name = "sfa_audit_transregional", tableNote = "窜货稽查表")
public class SfaAuditTransregionalEntity extends CrmExtTenEntity<SfaAuditTransregionalEntity> {


    /**
     * 稽查人员
     */
    @CrmColumn(name = "audit_inspector", length = 60, note = "稽查人员")
    private String auditInspector;

    /**
     * 稽查人员登录账号
     */
    @CrmColumn(name = "audit_account", length = 40, note = "登录账号")
    private String auditAccount;

    /**
     * 稽查编码
     */
    @CrmColumn(name = "audit_code", length = 32, note = "稽查编码")
    private String auditCode;


    /**
     * 区域
     */
    @CrmColumn(name = "audit_area", length = 200, note = "区域")
    private String auditArea;

    /**
     * 稽查区域编码
     */
    @CrmColumn(name="audit_area_code",length = 200,note = "稽查区域编码")
    private String auditAreaCode;


    /**
     * 稽查终端
     */
    @CrmColumn(name = "audit_terminal", length = 60, note = "稽查终端")
    private String auditTerminal;


    /**
     * 终端编码
     */
    @CrmColumn(name = "terminal_code", length = 32, note = "终端编码")
    private String terminalCode;


    /**
     * 稽查时间
     */
    @CrmColumn(name = "audit_date", length = 32, note = "稽查时间")
    private String auditDate;


    /**
     * 稽查结果
     */
    @CrmColumn(name = "audit_result", length = 10, note = "稽查结果")
    private Boolean auditResult;


    /**
     * 稽查结果描述
     */
    @CrmColumn(name = "audit_result_desc", length = 500, note = "稽查结果描述")
    private String auditResultDesc;


    /**
     * 稽查图片
     */
    @CrmColumn(name = "audit_picture", length = 200, note = "稽查图片")
    private String auditPicture;

}
