package com.biz.crm.audit.service;

import com.biz.crm.audit.model.SfaAuditAttendanceEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditAttendanceRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditAttendanceReqVo;

import java.util.Map;

/**
 * 考勤稽查表接口
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
public interface ISfaAuditAttendanceService extends IService<SfaAuditAttendanceEntity> {

    /**
     * 列表
     * @param sfaAuditAttendanceReqVo
     * @return PageResult<SfaAuditAttendanceRespVo>
     */
    PageResult<SfaAuditAttendanceRespVo> findList(SfaAuditAttendanceReqVo sfaAuditAttendanceReqVo);

    /**
     * 查询
     * @param sfaAuditAttendanceReqVo
     * @return SfaAuditAttendanceRespVo
     */
    SfaAuditAttendanceRespVo query(SfaAuditAttendanceReqVo sfaAuditAttendanceReqVo);

    /**
     * 新增
     * @param sfaAuditAttendanceReqVo
     * @return
     */
    void save(SfaAuditAttendanceReqVo sfaAuditAttendanceReqVo);

    /**
     * 更新
     * @param sfaAuditAttendanceReqVo
     * @return
     */
    void update(SfaAuditAttendanceReqVo sfaAuditAttendanceReqVo);

    /**
     * 删除
     * @param sfaAuditAttendanceReqVo
     * @return
     */
    void deleteBatch(SfaAuditAttendanceReqVo sfaAuditAttendanceReqVo);

    /**
     * 启用
     * @param sfaAuditAttendanceReqVo
     * @return
     */
    void enableBatch(SfaAuditAttendanceReqVo sfaAuditAttendanceReqVo);

    /**
     * 禁用
     * @param sfaAuditAttendanceReqVo
     * @return
     */
    void disableBatch(SfaAuditAttendanceReqVo sfaAuditAttendanceReqVo);
}

