package com.biz.crm.audit.service;

import com.biz.crm.audit.model.SfaAuditInspectorsEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditInspectorsRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditInspectorsReqVo;

import java.util.List;
import java.util.Map;

/**
 * 稽查人员区域配置表接口
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
public interface ISfaAuditInspectorsService extends IService<SfaAuditInspectorsEntity> {

    /**
     * 列表
     * @param sfaAuditInspectorsReqVo
     * @return PageResult<SfaAuditInspectorsRespVo>
     */
    PageResult<SfaAuditInspectorsRespVo> findList(SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo);

    /**
     * 查询
     * @param sfaAuditInspectorsReqVo
     * @return SfaAuditInspectorsRespVo
     */
    SfaAuditInspectorsRespVo query(SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo);

    /**
     * 新增
     * @param sfaAuditInspectorsReqVo
     * @return
     */
    void save(SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo);

    /**
     * 更新
     * @param sfaAuditInspectorsReqVo
     * @return
     */
    void update(SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo);

    /**
     * 删除
     * @param sfaAuditInspectorsReqVo
     * @return
     */
    void deleteBatch(SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo);

    /**
     * 启用
     * @param sfaAuditInspectorsReqVo
     * @return
     */
    void enableBatch(SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo);

    /**
     * 禁用
     * @param sfaAuditInspectorsReqVo
     * @return
     */
    void disableBatch(SfaAuditInspectorsReqVo sfaAuditInspectorsReqVo);

    /**
     * 根据登录账号获得稽查人员配置信息
     */
    SfaAuditInspectorsRespVo queryInfoByAccount(String auditAccount);

}

