package com.biz.crm.audit.service;

import com.biz.crm.audit.model.SfaAuditProductPriceProEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditProductPriceProRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditProductPriceProReqVo;

import java.util.Map;

/**
 * 产品价格稽查-产品表接口
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
public interface ISfaAuditProductPriceProService extends IService<SfaAuditProductPriceProEntity> {

    /**
     * 列表
     * @param sfaAuditProductPriceProReqVo
     * @return PageResult<SfaAuditProductPriceProRespVo>
     */
    PageResult<SfaAuditProductPriceProRespVo> findList(SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo);

    /**
     * 查询
     * @param sfaAuditProductPriceProReqVo
     * @return SfaAuditProductPriceProRespVo
     */
    SfaAuditProductPriceProRespVo query(SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo);

    /**
     * 新增
     * @param sfaAuditProductPriceProReqVo
     * @return
     */
    void save(SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo);

    /**
     * 更新
     * @param sfaAuditProductPriceProReqVo
     * @return
     */
    void update(SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo);

    /**
     * 删除
     * @param sfaAuditProductPriceProReqVo
     * @return
     */
    void deleteBatch(SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo);

    /**
     * 启用
     * @param sfaAuditProductPriceProReqVo
     * @return
     */
    void enableBatch(SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo);

    /**
     * 禁用
     * @param sfaAuditProductPriceProReqVo
     * @return
     */
    void disableBatch(SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo);
}

