package com.biz.crm.audit.service;

import com.biz.crm.audit.model.SfaAuditProductPriceEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditProductPriceRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditProductPriceReqVo;

import java.util.List;

/**
 * 产品价格稽查主表接口
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
public interface ISfaAuditProductPriceService extends IService<SfaAuditProductPriceEntity> {

    /**
     * 列表
     * @param sfaAuditProductPriceReqVo
     * @return PageResult<SfaAuditProuditPriceRespVo>
     */
    PageResult<SfaAuditProductPriceRespVo> findList(SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo);

    /**
     * 查询
     * @param sfaAuditProductPriceReqVo
     * @return SfaAuditProuditPriceRespVo
     */
    SfaAuditProductPriceRespVo query(SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo);

    /**
     * 新增
     * @param sfaAuditProductPriceReqVo
     * @return
     */
    void save(SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo);

    /**
     * 更新
     * @param sfaAuditProductPriceReqVo
     * @return
     */
    void update(SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo);

    /**
     * 删除
     * @param sfaAuditProductPriceReqVo
     * @return
     */
    void deleteBatch(SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo);

    /**
     * 启用
     * @param sfaAuditProductPriceReqVo
     * @return
     */
    void enableBatch(SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo);

    /**
     * 禁用
     * @param sfaAuditProductPriceReqVo
     * @return
     */
    void disableBatch(SfaAuditProductPriceReqVo sfaAuditProductPriceReqVo);

    /**
     * 根据终端编码查询稽查记录
     */
    List<SfaAuditProductPriceRespVo> queryProductAudit (SfaAuditProductPriceReqVo reqVo);

    /**
     * 根据稽查编码查询稽查详情
     */
    SfaAuditProductPriceRespVo queryProductAuditDetail(SfaAuditProductPriceReqVo reqVo);
}

