package com.biz.crm.audit.service;

import com.biz.crm.audit.model.SfaAuditTerminalRealEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTerminalRealRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditTerminalRealReqVo;

import java.util.List;
import java.util.Map;

/**
 * 终端真实性稽查表接口
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
public interface ISfaAuditTerminalRealService extends IService<SfaAuditTerminalRealEntity> {

    /**
     * 列表
     * @param sfaAuditTerminalRealReqVo
     * @return PageResult<SfaAuditTerminalRealRespVo>
     */
    PageResult<SfaAuditTerminalRealRespVo> findList(SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo);

    /**
     * 查询
     * @param sfaAuditTerminalRealReqVo
     * @return SfaAuditTerminalRealRespVo
     */
    SfaAuditTerminalRealRespVo query(SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo);

    /**
     * 新增
     * @param sfaAuditTerminalRealReqVo
     * @return
     */
    void save(SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo);

    /**
     * 更新
     * @param sfaAuditTerminalRealReqVo
     * @return
     */
    void update(SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo);

    /**
     * 删除
     * @param sfaAuditTerminalRealReqVo
     * @return
     */
    void deleteBatch(SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo);

    /**
     * 启用
     * @param sfaAuditTerminalRealReqVo
     * @return
     */
    void enableBatch(SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo);

    /**
     * 禁用
     * @param sfaAuditTerminalRealReqVo
     * @return
     */
    void disableBatch(SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo);

    /**
     * 根据终端编码查询稽查记录
     */
    List<SfaAuditTerminalRealRespVo> queryTerminalAudit(SfaAuditTerminalRealReqVo reqVo);

    /**
     * 根据稽查编码查询稽查记录详情
     */
    SfaAuditTerminalRealRespVo queryTerminalAuditDetail(SfaAuditTerminalRealReqVo reqVo);
}

