package com.biz.crm.audit.service;

import com.biz.crm.audit.model.SfaAuditTpmEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.sfa.audit.req.SfaTPMTerminalReqVo;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTpmActInfoRespVo;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTpmRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditTpmReqVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActReqVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActRespVo;

import java.util.List;
import java.util.Map;

/**
 * TPM稽查表接口
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
public interface ISfaAuditTpmService extends IService<SfaAuditTpmEntity> {

    /**
     * 列表
     * @param sfaAuditTpmReqVo
     * @return PageResult<SfaAuditTpmRespVo>
     */
    PageResult<SfaAuditTpmRespVo> findList(SfaAuditTpmReqVo sfaAuditTpmReqVo);

    /**
     * 查询
     * @param sfaAuditTpmReqVo
     * @return SfaAuditTpmRespVo
     */
    SfaAuditTpmRespVo query(SfaAuditTpmReqVo sfaAuditTpmReqVo);

    /**
     * 新增
     * @param sfaAuditTpmReqVo
     * @return
     */
    void save(SfaAuditTpmReqVo sfaAuditTpmReqVo);

    /**
     * 更新
     * @param sfaAuditTpmReqVo
     * @return
     */
    void update(SfaAuditTpmReqVo sfaAuditTpmReqVo);

    /**
     * 删除
     * @param sfaAuditTpmReqVo
     * @return
     */
    void deleteBatch(SfaAuditTpmReqVo sfaAuditTpmReqVo);

    /**
     * 启用
     * @param sfaAuditTpmReqVo
     * @return
     */
    void enableBatch(SfaAuditTpmReqVo sfaAuditTpmReqVo);

    /**
     * 禁用
     * @param sfaAuditTpmReqVo
     * @return
     */
    void disableBatch(SfaAuditTpmReqVo sfaAuditTpmReqVo);

    /**
     * 查看TPM终端信息
     */
    List<MdmTerminalVo> queryTpmInfo(SfaTPMTerminalReqVo reqVo);

    /**
     * 根据稽查终端编码查看稽查记录
     */
    List<SfaAuditTpmRespVo> queryTpmByTerminalCode(SfaAuditTpmReqVo reqVo);

    /**
     * 查看终端下已稽查TPM活动
     */
    List<SfaTpmActRespVo> queryTpmAuditAct(SfaTpmActReqVo reqVo);

    /**
     * 查看终端下待稽查的TPM活动
     */
    List<SfaTpmActRespVo> queryTpmToAuditAct(SfaTpmActReqVo reqVo);

    /**
     * 查看终端下TPM活动详情信息
     */
    List<SfaAuditTpmActInfoRespVo> queryTpmActDetail(SfaAuditTpmReqVo reqVo);

    /**
     * 查看TPM费用活动稽查明细
     */
    List<SfaAuditTpmActInfoRespVo> queryTpmActAuditDetail(SfaAuditTpmReqVo reqVo);
}

