package com.biz.crm.audit.service;

import com.biz.crm.audit.model.SfaAuditTransregionalEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditTerminalRealReqVo;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTerminalRealRespVo;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTransregionalRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditTransregionalReqVo;

import java.util.List;
import java.util.Map;

/**
 * 窜货稽查表接口
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
public interface ISfaAuditTransregionalService extends IService<SfaAuditTransregionalEntity> {

    /**
     * 列表
     * @param sfaAuditTransregionalReqVo
     * @return PageResult<SfaAuditTransregionalRespVo>
     */
    PageResult<SfaAuditTransregionalRespVo> findList(SfaAuditTransregionalReqVo sfaAuditTransregionalReqVo);

    /**
     * 查询
     * @param sfaAuditTransregionalReqVo
     * @return SfaAuditTransregionalRespVo
     */
    SfaAuditTransregionalRespVo query(SfaAuditTransregionalReqVo sfaAuditTransregionalReqVo);

    /**
     * 新增
     * @param sfaAuditTransregionalReqVo
     * @return
     */
    void save(SfaAuditTransregionalReqVo sfaAuditTransregionalReqVo);

    /**
     * 更新
     * @param sfaAuditTransregionalReqVo
     * @return
     */
    void update(SfaAuditTransregionalReqVo sfaAuditTransregionalReqVo);

    /**
     * 删除
     * @param sfaAuditTransregionalReqVo
     * @return
     */
    void deleteBatch(SfaAuditTransregionalReqVo sfaAuditTransregionalReqVo);

    /**
     * 启用
     * @param sfaAuditTransregionalReqVo
     * @return
     */
    void enableBatch(SfaAuditTransregionalReqVo sfaAuditTransregionalReqVo);

    /**
     * 禁用
     * @param sfaAuditTransregionalReqVo
     * @return
     */
    void disableBatch(SfaAuditTransregionalReqVo sfaAuditTransregionalReqVo);

    /**
     * 根据终端编码查询稽查记录
     */
    List<SfaAuditTransregionalRespVo> queryTransregionalAudit(SfaAuditTransregionalReqVo reqVo);

    /**
     * 根据稽查编码查询稽查记录详情
     */
    SfaAuditTransregionalRespVo queryTransregionalAuditDetail(SfaAuditTransregionalReqVo reqVo);
}

