package com.biz.crm.audit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.audit.mapper.SfaAuditAttendanceMapper;
import com.biz.crm.audit.model.SfaAuditAttendanceEntity;
import com.biz.crm.audit.service.ISfaAuditAttendanceService;
import com.biz.crm.audit.service.ISfaAuditInspectorsService;
import com.biz.crm.audit.service.ISfaAuditTerminalCommonService;
import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.mdm.product.req.MdmProductBySfaReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductBySfaRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditInspectorsReqVo;
import com.biz.crm.nebular.sfa.audit.req.SfaTPMTerminalReqVo;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditInspectorsRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

/**
 * 终端-登录账号获取终端信息接口
 *
 * @author rwm
 * @date 2022-04-19
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaAuditTerminalCommonServiceExpandImpl")
public class ISfaAuditTerminalCommonServiceImpl implements ISfaAuditTerminalCommonService {

    @Resource
    private ISfaAuditInspectorsService inspectorsService;

    @Resource
    private MdmTerminalFeign mdmTerminalFeign;

    @Resource
    private MdmProductFeign mdmProductFeign;

    @Override
    public boolean saveBatch(Collection<MdmTerminalVo> entityList, int batchSize) {
        return false;
    }

    @Override
    public boolean saveOrUpdateBatch(Collection<MdmTerminalVo> entityList, int batchSize) {
        return false;
    }

    @Override
    public boolean updateBatchById(Collection<MdmTerminalVo> entityList, int batchSize) {
        return false;
    }

    @Override
    public boolean saveOrUpdate(MdmTerminalVo entity) {
        return false;
    }

    @Override
    public MdmTerminalVo getOne(Wrapper<MdmTerminalVo> queryWrapper, boolean throwEx) {
        return null;
    }

    @Override
    public Map<String, Object> getMap(Wrapper<MdmTerminalVo> queryWrapper) {
        return null;
    }

    @Override
    public <V> V getObj(Wrapper<MdmTerminalVo> queryWrapper, Function<? super Object, V> mapper) {
        return null;
    }

    @Override
    public BaseMapper<MdmTerminalVo> getBaseMapper() {
        return null;
    }

    @Override
    public List<MdmTerminalVo> queryTpmInfo(SfaTPMTerminalReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getAuditAccount(),"登录账号不能不空");
        //获取登录账号配置的区域
        SfaAuditInspectorsRespVo respVo = inspectorsService.queryInfoByAccount(reqVo.getAuditAccount());
        List<String> auditAreaCode = respVo.getAuditAreaCode();
        reqVo.setAuditAreaCode(auditAreaCode);
        //调用接口
        Result<List<MdmTerminalVo>> listResult = mdmTerminalFeign.queryTerminalByOrgCodeList(reqVo);
        List<MdmTerminalVo> result = listResult.getResult();
        return result;
    }

    @Override
    public List<MdmProductBySfaRespVo> queryAllProduct(MdmProductBySfaReqVo reqVo) {
        Result<PageResult<MdmProductBySfaRespVo>> sfa = mdmProductFeign.findProductListSourceSfa(reqVo);
        List<MdmProductBySfaRespVo> data = sfa.getResult().getData();
        return data;
    }
}
