package com.biz.crm.audit.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.*;
import com.biz.crm.audit.model.SfaAuditAttendanceEntity;
import com.biz.crm.audit.mapper.SfaAuditAttendanceMapper;
import com.biz.crm.audit.service.ISfaAuditAttendanceService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditAttendanceRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditAttendanceReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * 考勤稽查表接口实现
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaAuditAttendanceServiceExpandImpl")
public class SfaAuditAttendanceServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaAuditAttendanceMapper, SfaAuditAttendanceEntity> implements ISfaAuditAttendanceService {

    @Resource
    private SfaAuditAttendanceMapper sfaAuditAttendanceMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaAuditAttendanceRespVo> findList(SfaAuditAttendanceReqVo reqVo){
        Page<SfaAuditAttendanceRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaAuditAttendanceRespVo> list = sfaAuditAttendanceMapper.findList(page, reqVo);
        return PageResult.<SfaAuditAttendanceRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaAuditAttendanceRespVo
     */
    @Override
    public SfaAuditAttendanceRespVo query(SfaAuditAttendanceReqVo reqVo){
        AssertUtils.isNotEmpty(reqVo.getId(),"id不能为空");
        SfaAuditAttendanceEntity sfaAuditAttendanceEntity = sfaAuditAttendanceMapper.selectById(reqVo.getId());
        SfaAuditAttendanceRespVo respVo = CrmBeanUtil.copy(sfaAuditAttendanceEntity, SfaAuditAttendanceRespVo.class);
        return respVo;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaAuditAttendanceReqVo reqVo){
        SfaAuditAttendanceEntity entity = CrmBeanUtil.copy(reqVo,SfaAuditAttendanceEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaAuditAttendanceReqVo reqVo){
        SfaAuditAttendanceEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaAuditAttendanceReqVo reqVo){
        List<SfaAuditAttendanceEntity> sfaAuditAttendanceEntities = sfaAuditAttendanceMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaAuditAttendanceEntities)){
            sfaAuditAttendanceEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaAuditAttendanceEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaAuditAttendanceReqVo reqVo){
        //设置状态为启用
        List<SfaAuditAttendanceEntity> sfaAuditAttendanceEntities = sfaAuditAttendanceMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaAuditAttendanceEntities)){
            sfaAuditAttendanceEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaAuditAttendanceEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaAuditAttendanceReqVo reqVo){
        //设置状态为禁用
        List<SfaAuditAttendanceEntity> sfaAuditAttendanceEntities = sfaAuditAttendanceMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaAuditAttendanceEntities)){
                sfaAuditAttendanceEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaAuditAttendanceEntities);
    }
}
