package com.biz.crm.audit.service.impl;

import com.biz.crm.audit.trans.SfaAuditInspectorEntityToResp;
import com.biz.crm.audit.trans.SfaAuditInspectorsReqToEntity;
import com.biz.crm.audit.utils.Constant;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.*;
import com.biz.crm.audit.model.SfaAuditInspectorsEntity;
import com.biz.crm.audit.mapper.SfaAuditInspectorsMapper;
import com.biz.crm.audit.service.ISfaAuditInspectorsService;
import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditInspectorsRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditInspectorsReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * 稽查人员区域配置表接口实现
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaAuditInspectorsServiceExpandImpl")
public class SfaAuditInspectorsServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaAuditInspectorsMapper, SfaAuditInspectorsEntity> implements ISfaAuditInspectorsService {

    @Resource
    private SfaAuditInspectorsMapper sfaAuditInspectorsMapper;

    @Resource
    private MdmOrgFeign mdmOrgFeign;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaAuditInspectorsRespVo> findList(SfaAuditInspectorsReqVo reqVo){
        Page<SfaAuditInspectorsRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaAuditInspectorsRespVo> list = sfaAuditInspectorsMapper.findList(page, reqVo);
        //添加区域集合
        for (SfaAuditInspectorsRespVo respVo : list) {
            SfaAuditInspectorsEntity entity = sfaAuditInspectorsMapper.selectById(respVo.getId());
            SfaAuditInspectorsRespVo apply = new SfaAuditInspectorEntityToResp().apply(entity);
            respVo.setAuditArea(apply.getAuditArea());
            respVo.setAuditAreaCode(apply.getAuditAreaCode());
        }
        return PageResult.<SfaAuditInspectorsRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaAuditInspectorsRespVo
     */
    @Override
    public SfaAuditInspectorsRespVo query(SfaAuditInspectorsReqVo reqVo){
        AssertUtils.isNotEmpty(reqVo.getId(),"id不能为空");
        SfaAuditInspectorsEntity entity = sfaAuditInspectorsMapper.selectById(reqVo.getId());
        return new SfaAuditInspectorEntityToResp().apply(entity);
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaAuditInspectorsReqVo reqVo){
        AssertUtils.isNotEmpty(reqVo.getAuditAccount(),"登录账号不能为空");
        SfaAuditInspectorsEntity respVo = sfaAuditInspectorsMapper.queryInfoByAccount(reqVo.getAuditAccount());
        //同一登录账号不能设置多次
//        if (StringUtils.isNotBlank(respVo.getAuditAccount())){
//            AssertUtils.isTrue(false,"同一账号不能配置多次");
//        }

        SfaAuditInspectorsEntity entity = CrmBeanUtil.copy(reqVo,SfaAuditInspectorsEntity.class);
        List<String> auditAreaCodeList = reqVo.getAuditAreaCode();
        String auditAreaCode=Constant.NULLT;
        String auditArea=Constant.NULLT;
        if (CollectionUtils.isNotEmpty(auditAreaCodeList)){
            auditAreaCode= StringUtils.join(auditAreaCodeList,",");
        }
        Result<List<MdmOrgRespVo>> listResult = mdmOrgFeign.detailBatchByOrgCodeList(auditAreaCodeList);
        List<MdmOrgRespVo> result = listResult.getResult();
        List<String> collect = result.stream().map(MdmOrgRespVo::getOrgName).collect(Collectors.toList());
        auditArea=StringUtils.join(collect,",");

        entity.setAuditAreaCode(auditAreaCode);
        entity.setAuditArea(auditArea);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaAuditInspectorsReqVo reqVo){

        SfaAuditInspectorsEntity apply = new SfaAuditInspectorsReqToEntity().apply(reqVo);
//        SfaAuditInspectorsEntity entity = this.getById(reqVo.getId());
        this.updateById(apply);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaAuditInspectorsReqVo reqVo){
        List<SfaAuditInspectorsEntity> sfaAuditInspectorsEntities = sfaAuditInspectorsMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaAuditInspectorsEntities)){
            sfaAuditInspectorsEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaAuditInspectorsEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaAuditInspectorsReqVo reqVo){
        //设置状态为启用
        List<SfaAuditInspectorsEntity> sfaAuditInspectorsEntities = sfaAuditInspectorsMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaAuditInspectorsEntities)){
            sfaAuditInspectorsEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaAuditInspectorsEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaAuditInspectorsReqVo reqVo){
        //设置状态为禁用
        List<SfaAuditInspectorsEntity> sfaAuditInspectorsEntities = sfaAuditInspectorsMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaAuditInspectorsEntities)){
                sfaAuditInspectorsEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaAuditInspectorsEntities);
    }

    @Override
    public SfaAuditInspectorsRespVo queryInfoByAccount(String auditAccount) {
        AssertUtils.isNotEmpty(auditAccount,"登录账号不能为空");
        SfaAuditInspectorsEntity entity = sfaAuditInspectorsMapper.queryInfoByAccount(auditAccount);
        return new SfaAuditInspectorEntityToResp().apply(entity);
    }
}
