package com.biz.crm.audit.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.*;
import com.biz.crm.audit.model.SfaAuditProductPriceProEntity;
import com.biz.crm.audit.mapper.SfaAuditProductPriceProMapper;
import com.biz.crm.audit.service.ISfaAuditProductPriceProService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditProductPriceProRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditProductPriceProReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * 产品价格稽查-产品表接口实现
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaAuditProductPriceProServiceExpandImpl")
public class SfaAuditProductPriceProServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaAuditProductPriceProMapper, SfaAuditProductPriceProEntity> implements ISfaAuditProductPriceProService {

    @Resource
    private SfaAuditProductPriceProMapper sfaAuditProductPriceProMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaAuditProductPriceProRespVo> findList(SfaAuditProductPriceProReqVo reqVo){
        Page<SfaAuditProductPriceProRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaAuditProductPriceProRespVo> list = sfaAuditProductPriceProMapper.findList(page, reqVo);
        return PageResult.<SfaAuditProductPriceProRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaAuditProductPriceProRespVo
     */
    @Override
    public SfaAuditProductPriceProRespVo query(SfaAuditProductPriceProReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaAuditProductPriceProReqVo reqVo){
        SfaAuditProductPriceProEntity entity = CrmBeanUtil.copy(reqVo,SfaAuditProductPriceProEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaAuditProductPriceProReqVo reqVo){
        SfaAuditProductPriceProEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaAuditProductPriceProReqVo reqVo){
        List<SfaAuditProductPriceProEntity> sfaAuditProductPriceProEntities = sfaAuditProductPriceProMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaAuditProductPriceProEntities)){
            sfaAuditProductPriceProEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaAuditProductPriceProEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaAuditProductPriceProReqVo reqVo){
        //设置状态为启用
        List<SfaAuditProductPriceProEntity> sfaAuditProductPriceProEntities = sfaAuditProductPriceProMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaAuditProductPriceProEntities)){
            sfaAuditProductPriceProEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaAuditProductPriceProEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaAuditProductPriceProReqVo reqVo){
        //设置状态为禁用
        List<SfaAuditProductPriceProEntity> sfaAuditProductPriceProEntities = sfaAuditProductPriceProMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaAuditProductPriceProEntities)){
                sfaAuditProductPriceProEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaAuditProductPriceProEntities);
    }
}
