package com.biz.crm.audit.service.impl;

import com.biz.crm.audit.mapper.SfaAuditProductPriceProMapper;
import com.biz.crm.audit.model.SfaAuditProductPriceProEntity;
import com.biz.crm.audit.service.ISfaAuditProductPriceProService;
import com.biz.crm.audit.utils.AuditAccountUtils;
import com.biz.crm.audit.utils.SfaAuditAreaUtils;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditProductPriceProReqVo;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditProductPriceProRespVo;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.*;
import com.biz.crm.audit.model.SfaAuditProductPriceEntity;
import com.biz.crm.audit.mapper.SfaAuditProductPriceMapper;
import com.biz.crm.audit.service.ISfaAuditProductPriceService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditProductPriceRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditProductPriceReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * 产品价格稽查主表接口实现
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaAuditProuditPriceServiceExpandImpl")
public class SfaAuditProductPriceServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaAuditProductPriceMapper, SfaAuditProductPriceEntity> implements ISfaAuditProductPriceService {

    @Resource
    private SfaAuditProductPriceMapper sfaAuditProuditPriceMapper;
    @Resource
    private SfaAuditProductPriceProMapper sfaAuditProductPriceProMapper;
    @Resource
    private ISfaAuditProductPriceProService iSfaAuditProductPriceProService;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaAuditProductPriceRespVo> findList(SfaAuditProductPriceReqVo reqVo){
        Page<SfaAuditProductPriceRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaAuditProductPriceRespVo> list = sfaAuditProuditPriceMapper.findList(page, reqVo);

        return PageResult.<SfaAuditProductPriceRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaAuditProuditPriceRespVo
     */
    @Override
    public SfaAuditProductPriceRespVo query(SfaAuditProductPriceReqVo reqVo){
        AssertUtils.isNotEmpty(reqVo.getId(),"id不能为空");
        SfaAuditProductPriceEntity entity = sfaAuditProuditPriceMapper.selectById(reqVo.getId());
        SfaAuditProductPriceRespVo respVo = CrmBeanUtil.copy(entity, SfaAuditProductPriceRespVo.class);
        List<SfaAuditProductPriceProRespVo> proList = sfaAuditProductPriceProMapper.findListByProductId(respVo.getId());
        respVo.setProductPriceProRespVos(proList);
        return respVo;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaAuditProductPriceReqVo reqVo){
        AssertUtils.isNotEmpty(reqVo.getAuditAccount(),"登录账号不能为空");
        //设置稽查产品编码
        reqVo.setAuditCode(CodeUtil.createCode());
        reqVo.setAuditProductQuantity(reqVo.getAuditProductList().size());
        Map<String, String> areaInfo = new AuditAccountUtils().getAreaInfo(reqVo.getAuditAccount());
        List<SfaAuditProductPriceProRespVo> auditProductList = reqVo.getAuditProductList();
        Integer unqualifiedProductQuantity=0;
        //设置产品数量、不合格数量、是否合格
        if (CollectionUtils.isNotEmpty(auditProductList)){
            for (SfaAuditProductPriceProRespVo vo : auditProductList) {
                if (!vo.getSalesTarget()){
                    unqualifiedProductQuantity++;
                    reqVo.setAuditResult(false);
                }
                SfaAuditProductPriceProReqVo copy = CrmBeanUtil.copy(vo, SfaAuditProductPriceProReqVo.class);
                copy.setAuditCode(reqVo.getAuditCode());
                iSfaAuditProductPriceProService.save(copy);
            }
        }

        reqVo.setUnqualifiedProductQuantity(unqualifiedProductQuantity);
        SfaAuditProductPriceEntity entity = CrmBeanUtil.copy(reqVo, SfaAuditProductPriceEntity.class);
        entity.setAuditAreaCode(areaInfo.get("code"));
        entity.setAuditArea(areaInfo.get("name"));
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaAuditProductPriceReqVo reqVo){
        SfaAuditProductPriceEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaAuditProductPriceReqVo reqVo){
        List<SfaAuditProductPriceEntity> sfaAuditProuditPriceEntities = sfaAuditProuditPriceMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaAuditProuditPriceEntities)){
            sfaAuditProuditPriceEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaAuditProuditPriceEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaAuditProductPriceReqVo reqVo){
        //设置状态为启用
        List<SfaAuditProductPriceEntity> sfaAuditProuditPriceEntities = sfaAuditProuditPriceMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaAuditProuditPriceEntities)){
            sfaAuditProuditPriceEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaAuditProuditPriceEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaAuditProductPriceReqVo reqVo){
        //设置状态为禁用
        List<SfaAuditProductPriceEntity> sfaAuditProuditPriceEntities = sfaAuditProuditPriceMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaAuditProuditPriceEntities)){
                sfaAuditProuditPriceEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaAuditProuditPriceEntities);
    }

    @Override
    public List<SfaAuditProductPriceRespVo> queryProductAudit(SfaAuditProductPriceReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getTerminalCode(),"终端编码不能为空");
        List<SfaAuditProductPriceRespVo> respVos = sfaAuditProuditPriceMapper.queryByTerminalCode(reqVo);
        return respVos;
    }

    @Override
    public SfaAuditProductPriceRespVo queryProductAuditDetail(SfaAuditProductPriceReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getAuditCode(),"稽查编码不能为空");
        SfaAuditProductPriceRespVo respVos = sfaAuditProuditPriceMapper.queryAuditDetailByCode(reqVo);
        return respVos;
    }
}
