package com.biz.crm.audit.service.impl;

import com.biz.crm.audit.utils.AuditAccountUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.*;
import com.biz.crm.audit.model.SfaAuditTerminalRealEntity;
import com.biz.crm.audit.mapper.SfaAuditTerminalRealMapper;
import com.biz.crm.audit.service.ISfaAuditTerminalRealService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTerminalRealRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditTerminalRealReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * 终端真实性稽查表接口实现
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaAuditTerminalRealServiceExpandImpl")
public class SfaAuditTerminalRealServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaAuditTerminalRealMapper, SfaAuditTerminalRealEntity> implements ISfaAuditTerminalRealService {

    @Resource
    private SfaAuditTerminalRealMapper sfaAuditTerminalRealMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaAuditTerminalRealRespVo> findList(SfaAuditTerminalRealReqVo reqVo){
        Page<SfaAuditTerminalRealRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaAuditTerminalRealRespVo> list = sfaAuditTerminalRealMapper.findList(page, reqVo);
        return PageResult.<SfaAuditTerminalRealRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaAuditTerminalRealRespVo
     */
    @Override
    public SfaAuditTerminalRealRespVo query(SfaAuditTerminalRealReqVo reqVo){
        AssertUtils.isNotEmpty(reqVo.getId(),"id不能为空");
        SfaAuditTerminalRealEntity sfaAuditTerminalRealEntity = sfaAuditTerminalRealMapper.selectById(reqVo.getId());
        SfaAuditTerminalRealRespVo respVo = CrmBeanUtil.copy(sfaAuditTerminalRealEntity, SfaAuditTerminalRealRespVo.class);
        return respVo;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaAuditTerminalRealReqVo reqVo){
        AssertUtils.isNotEmpty(reqVo.getAuditAccount(),"登录账号不能为空");
        reqVo.setAuditCode(CodeUtil.createCode());
        Map<String, String> areaInfo = new AuditAccountUtils().getAreaInfo(reqVo.getAuditAccount());
        SfaAuditTerminalRealEntity entity = CrmBeanUtil.copy(reqVo,SfaAuditTerminalRealEntity.class);
        entity.setAuditAreaCode(areaInfo.get("code"));
        entity.setAuditArea(areaInfo.get("name"));
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaAuditTerminalRealReqVo reqVo){
        SfaAuditTerminalRealEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaAuditTerminalRealReqVo reqVo){
        List<SfaAuditTerminalRealEntity> sfaAuditTerminalRealEntities = sfaAuditTerminalRealMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaAuditTerminalRealEntities)){
            sfaAuditTerminalRealEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaAuditTerminalRealEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaAuditTerminalRealReqVo reqVo){
        //设置状态为启用
        List<SfaAuditTerminalRealEntity> sfaAuditTerminalRealEntities = sfaAuditTerminalRealMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaAuditTerminalRealEntities)){
            sfaAuditTerminalRealEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaAuditTerminalRealEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaAuditTerminalRealReqVo reqVo){
        //设置状态为禁用
        List<SfaAuditTerminalRealEntity> sfaAuditTerminalRealEntities = sfaAuditTerminalRealMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaAuditTerminalRealEntities)){
                sfaAuditTerminalRealEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaAuditTerminalRealEntities);
    }

    @Override
    public List<SfaAuditTerminalRealRespVo> queryTerminalAudit(SfaAuditTerminalRealReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getTerminalCode(),"终端编码不能为空");
        List<SfaAuditTerminalRealRespVo> respVos = sfaAuditTerminalRealMapper.queryAuditByTerminalCode(reqVo);
        return respVos;
    }

    @Override
    public SfaAuditTerminalRealRespVo queryTerminalAuditDetail(SfaAuditTerminalRealReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getAuditCode(),"稽查编码不能为空");
        SfaAuditTerminalRealRespVo respVo = sfaAuditTerminalRealMapper.queryAuditByAuditCode(reqVo);
        return respVo;
    }
}
