package com.biz.crm.audit.service.impl;

import com.biz.crm.audit.service.ISfaAuditInspectorsService;
import com.biz.crm.audit.trans.SfaAuditAndActToActDetail;
import com.biz.crm.audit.utils.SfaAuditAreaUtils;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.sfa.audit.req.SfaTPMTerminalReqVo;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditInspectorsRespVo;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTpmActInfoRespVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActReqVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActRespVo;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailRespVo;
import com.biz.crm.tpm.act.TpmActDetailFeign;
import com.biz.crm.tpmact.service.ISfaTpmActDetailService;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.*;
import com.biz.crm.audit.model.SfaAuditTpmEntity;
import com.biz.crm.audit.mapper.SfaAuditTpmMapper;
import com.biz.crm.audit.service.ISfaAuditTpmService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTpmRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditTpmReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * TPM稽查表接口实现
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaAuditTpmServiceExpandImpl")
public class SfaAuditTpmServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaAuditTpmMapper, SfaAuditTpmEntity> implements ISfaAuditTpmService {

    @Resource
    private SfaAuditTpmMapper sfaAuditTpmMapper;

    @Resource
    private ISfaAuditInspectorsService inspectorsService;

    @Resource
    private MdmTerminalFeign mdmTerminalFeign;

    @Resource
    private ISfaTpmActDetailService iSfaTpmActDetailService;

    @Resource
    private TpmActDetailFeign tpmActDetailFeign;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaAuditTpmRespVo> findList(SfaAuditTpmReqVo reqVo){
        Page<SfaAuditTpmRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaAuditTpmRespVo> list = sfaAuditTpmMapper.findList(page, reqVo);
        return PageResult.<SfaAuditTpmRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaAuditTpmRespVo
     */
    @Override
    public SfaAuditTpmRespVo query(SfaAuditTpmReqVo reqVo){
        AssertUtils.isNotEmpty(reqVo.getId(),"id不能为空");
        SfaAuditTpmEntity sfaAuditTpmEntity = sfaAuditTpmMapper.selectById(reqVo.getId());
        SfaAuditTpmRespVo respVo = CrmBeanUtil.copy(sfaAuditTpmEntity, SfaAuditTpmRespVo.class);
        return respVo;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaAuditTpmReqVo reqVo){
        SfaAuditTpmEntity entity = CrmBeanUtil.copy(reqVo,SfaAuditTpmEntity.class);
        Map<String, String> auditArea = new SfaAuditAreaUtils().getAuditArea(reqVo.getAuditAreaCode());
        entity.setAuditAreaCode(auditArea.get("code"));
        entity.setAuditArea(auditArea.get("name"));
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaAuditTpmReqVo reqVo){
        SfaAuditTpmEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaAuditTpmReqVo reqVo){
        List<SfaAuditTpmEntity> sfaAuditTpmEntities = sfaAuditTpmMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaAuditTpmEntities)){
            sfaAuditTpmEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaAuditTpmEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaAuditTpmReqVo reqVo){
        //设置状态为启用
        List<SfaAuditTpmEntity> sfaAuditTpmEntities = sfaAuditTpmMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaAuditTpmEntities)){
            sfaAuditTpmEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaAuditTpmEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaAuditTpmReqVo reqVo){
        //设置状态为禁用
        List<SfaAuditTpmEntity> sfaAuditTpmEntities = sfaAuditTpmMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaAuditTpmEntities)){
                sfaAuditTpmEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaAuditTpmEntities);
    }

    @Override
    public List<MdmTerminalVo> queryTpmInfo(SfaTPMTerminalReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getAuditAccount(),"登录账号不能不空");
        SfaAuditInspectorsRespVo respVo = inspectorsService.queryInfoByAccount(reqVo.getAuditAccount());
        List<String> auditAreaCode = respVo.getAuditAreaCode();
        reqVo.setAuditAreaCode(auditAreaCode);
        Result<List<MdmTerminalVo>> listResult = mdmTerminalFeign.queryTerminalByOrgCodeList(reqVo);
        List<MdmTerminalVo> result = listResult.getResult();
        return result;
    }

    @Override
    public List<SfaAuditTpmRespVo> queryTpmByTerminalCode(SfaAuditTpmReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getAuditTerminalCode(),"终端编码不能为空");
        List<SfaAuditTpmRespVo> sfaAuditTpmRespVos = sfaAuditTpmMapper.queryTpmByTerminal(reqVo);
        return sfaAuditTpmRespVos;
    }



    @Override
    public List<SfaTpmActRespVo> queryTpmAuditAct(SfaTpmActReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getTerminalCode(),"终端编码不能为空");
        //获得已稽查的活动编码
        List<SfaAuditTpmRespVo> sfaAuditTpmRespVos = sfaAuditTpmMapper.queryActCodeByTerminal(reqVo.getTerminalCode());
        List<String> auditActList = sfaAuditTpmRespVos.stream().map(SfaAuditTpmRespVo::getActCode).collect(Collectors.toList());
        //从活动信息中筛选中已稽查的活动
        List<SfaTpmActRespVo> tpmAuditList=Lists.newLinkedList();
        List<SfaTpmActRespVo> tpmAct = this.findTpmAct(reqVo);
        tpmAct.stream().forEach(o->{
            if (auditActList.contains(o.getActCode())){
                tpmAuditList.add(o);
            }
        });
        return tpmAuditList;
    }

    @Override
    public List<SfaTpmActRespVo> queryTpmToAuditAct(SfaTpmActReqVo reqVo) {
        //获得已稽查的活动编码
        List<SfaAuditTpmRespVo> AuditTpmRespVos = sfaAuditTpmMapper.queryActCodeByTerminal(reqVo.getTerminalCode());
        List<String> auditActList = AuditTpmRespVos.stream().map(SfaAuditTpmRespVo::getActCode).collect(Collectors.toList());
        //从活动信息中筛选中待稽查的活动
        List<SfaTpmActRespVo> tpmToAuditList=Lists.newLinkedList();
        List<SfaTpmActRespVo> tpmAct = this.findTpmAct(reqVo);
        tpmAct.stream().forEach(o->{
            if (!auditActList.contains(o.getActCode())){
                tpmToAuditList.add(o);
            }
        });
        return tpmToAuditList;
    }

    @Override
    public List<SfaAuditTpmActInfoRespVo> queryTpmActDetail(SfaAuditTpmReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getAuditTerminalCode(),"终端编码不能为空");
        AssertUtils.isNotEmpty(reqVo.getActCode(),"活动编码不能为空");
        TpmActDetailReqVo tpmReq=new TpmActDetailReqVo();
        //获得活动明细列表
        tpmReq.setActCode(reqVo.getActCode());
        Result<PageResult<TpmActDetailRespVo>> list = tpmActDetailFeign.list(tpmReq);
        List<TpmActDetailRespVo> data = list.getResult().getData();
        List<TpmActDetailRespVo> collect = data.stream().filter(o -> reqVo.getAuditTerminalCode().equals(o.getTerminalCode())).collect(Collectors.toList());
        //获得活动下的终端信息
        SfaAuditTpmReqVo auditReqVo=new SfaAuditTpmReqVo();
        auditReqVo.setAuditTerminalCode(reqVo.getAuditTerminalCode());
        List<SfaAuditTpmRespVo> sfaAuditTpmRespVos = this.queryTpmByTerminalCode(auditReqVo);
        Map<String, SfaAuditTpmRespVo> auditMap = sfaAuditTpmRespVos.stream().collect(Collectors.toMap(SfaAuditTpmRespVo::getAuditTerminalCode, vo -> vo, (v1, v2) -> v1));
        //组装完整的活动详情返回信息
        List<SfaAuditTpmActInfoRespVo> actInfo= Lists.newArrayList();
        collect.stream().forEach(o->{
            actInfo.add(new SfaAuditAndActToActDetail().apply(o));
        });
        actInfo.stream().forEach(o->{
            if (auditMap.containsKey(o.getTerminalCode())){
                o.setAuditAddress(auditMap.get(o.getTerminalCode()).getAuditAddress());
                o.setAuditDate(auditMap.get(o.getTerminalCode()).getAuditDate());
            }
        });
        return actInfo;
    }

    @Override
    public List<SfaAuditTpmActInfoRespVo> queryTpmActAuditDetail(SfaAuditTpmReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getAuditTerminalCode(),"终端编码不能为空");
        AssertUtils.isNotEmpty(reqVo.getActCode(),"活动编码不能为空");

        reqVo.setAuditCode(CodeUtil.createCode());
        TpmActDetailReqVo tpmReq=new TpmActDetailReqVo();
        //获得活动明细列表
        tpmReq.setActCode(reqVo.getActCode());
        Result<PageResult<TpmActDetailRespVo>> list = tpmActDetailFeign.list(tpmReq);
        List<TpmActDetailRespVo> data = list.getResult().getData();
        List<TpmActDetailRespVo> collect = data.stream().filter(o -> reqVo.getAuditTerminalCode().equals(o.getTerminalCode())).collect(Collectors.toList());
        //通过终端编码和活动编码获取稽查信息
        SfaAuditTpmReqVo auditReqVo=new SfaAuditTpmReqVo();
        auditReqVo.setAuditTerminalCode(reqVo.getAuditTerminalCode());
        auditReqVo.setActCode(reqVo.getActCode());
        List<SfaAuditTpmRespVo> sfaAuditTpmRespVos = sfaAuditTpmMapper.queryAuditByCodes(auditReqVo);
        Map<String,SfaAuditTpmRespVo> auditMap=sfaAuditTpmRespVos.stream().collect(Collectors.toMap(SfaAuditTpmRespVo::getAuditTerminalCode, vo -> vo, (v1, v2) -> v1));
        //组装完整的返回信息
        List<SfaAuditTpmActInfoRespVo> actInfos= Lists.newArrayList();
        collect.stream().forEach(o->{
            actInfos.add(new SfaAuditAndActToActDetail().apply(o));
        });
        actInfos.stream().forEach(o->{
            if (auditMap.containsKey(o.getTerminalCode())){
                o.setAuditAddress(auditMap.get(o.getTerminalCode()).getAuditAddress());
                o.setAuditDate(auditMap.get(o.getTerminalCode()).getAuditDate());
                o.setAuditResult(auditMap.get(o.getTerminalCode()).getAuditResult());
                o.setAuditResultDesc(auditMap.get(o.getTerminalCode()).getAuditResultDesc());
                o.setAuditPicture(auditMap.get(o.getTerminalCode()).getAuditPicture());
            }
        });
        return actInfos;
    }

    /**
     * 获得终端下的TPM活动信息list
     */
    private List<SfaTpmActRespVo> findTpmAct(SfaTpmActReqVo reqVo){
        AssertUtils.isNotEmpty(reqVo.getTerminalCode(),"终端编码不能为空");
        List<SfaTpmActRespVo> tpmList= Lists.newArrayList();
        //查看进行中的活动
        reqVo.setSfaTpmActStatus(SfaCommonEnum.sfaTpmActStatus.onGoing.getValue());
        PageResult<SfaTpmActRespVo> tpmActListOnGoing = iSfaTpmActDetailService.getTpmActList(reqVo);
        tpmList.addAll(tpmActListOnGoing.getData());
        //查看已结束的活动
        reqVo.setSfaTpmActStatus(SfaCommonEnum.sfaTpmActStatus.alreadySuccess.getValue());
        PageResult<SfaTpmActRespVo> tpmActListAlready = iSfaTpmActDetailService.getTpmActList(reqVo);
        tpmList.addAll(tpmActListAlready.getData());
        return tpmList;
    }
}
