package com.biz.crm.audit.service.impl;

import com.biz.crm.audit.utils.AuditAccountUtils;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTerminalRealRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.*;
import com.biz.crm.audit.model.SfaAuditTransregionalEntity;
import com.biz.crm.audit.mapper.SfaAuditTransregionalMapper;
import com.biz.crm.audit.service.ISfaAuditTransregionalService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTransregionalRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditTransregionalReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * 窜货稽查表接口实现
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaAuditTransregionalServiceExpandImpl")
public class SfaAuditTransregionalServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaAuditTransregionalMapper, SfaAuditTransregionalEntity> implements ISfaAuditTransregionalService {

    @Resource
    private SfaAuditTransregionalMapper sfaAuditTransregionalMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaAuditTransregionalRespVo> findList(SfaAuditTransregionalReqVo reqVo){
        Page<SfaAuditTransregionalRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaAuditTransregionalRespVo> list = sfaAuditTransregionalMapper.findList(page, reqVo);
        return PageResult.<SfaAuditTransregionalRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaAuditTransregionalRespVo
     */
    @Override
    public SfaAuditTransregionalRespVo query(SfaAuditTransregionalReqVo reqVo){
        AssertUtils.isNotEmpty(reqVo.getId(),"id不能为空");
        SfaAuditTransregionalEntity sfaAuditTransregionalEntity = sfaAuditTransregionalMapper.selectById(reqVo.getId());
        SfaAuditTransregionalRespVo respVo = CrmBeanUtil.copy(sfaAuditTransregionalEntity, SfaAuditTransregionalRespVo.class);
        return respVo;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaAuditTransregionalReqVo reqVo){
        AssertUtils.isNotEmpty(reqVo.getAuditAccount(),"登录账号不能为空");
        reqVo.setAuditCode(CodeUtil.createCode());
        Map<String, String> areaInfo = new AuditAccountUtils().getAreaInfo(reqVo.getAuditAccount());
        SfaAuditTransregionalEntity entity = CrmBeanUtil.copy(reqVo,SfaAuditTransregionalEntity.class);
        entity.setAuditAreaCode(areaInfo.get("code"));
        entity.setAuditArea(areaInfo.get("name"));
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaAuditTransregionalReqVo reqVo){
        SfaAuditTransregionalEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaAuditTransregionalReqVo reqVo){
        List<SfaAuditTransregionalEntity> sfaAuditTransregionalEntities = sfaAuditTransregionalMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaAuditTransregionalEntities)){
            sfaAuditTransregionalEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaAuditTransregionalEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaAuditTransregionalReqVo reqVo){
        //设置状态为启用
        List<SfaAuditTransregionalEntity> sfaAuditTransregionalEntities = sfaAuditTransregionalMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaAuditTransregionalEntities)){
            sfaAuditTransregionalEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaAuditTransregionalEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaAuditTransregionalReqVo reqVo){
        //设置状态为禁用
        List<SfaAuditTransregionalEntity> sfaAuditTransregionalEntities = sfaAuditTransregionalMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaAuditTransregionalEntities)){
                sfaAuditTransregionalEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaAuditTransregionalEntities);
    }

    @Override
    public List<SfaAuditTransregionalRespVo> queryTransregionalAudit(SfaAuditTransregionalReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getTerminalCode(),"终端编码不能为空");
        List<SfaAuditTransregionalRespVo> respVos = sfaAuditTransregionalMapper.queryAuditByTerminalCode(reqVo);
        return respVos;
    }

    @Override
    public SfaAuditTransregionalRespVo queryTransregionalAuditDetail(SfaAuditTransregionalReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getAuditCode(),"稽查编码不能为空");
        SfaAuditTransregionalRespVo respVo = sfaAuditTransregionalMapper.queryAuditByAuditCode(reqVo);
        return respVo;
    }
}
