package com.biz.crm.audit.trans;

import com.biz.crm.audit.model.SfaAuditInspectorsEntity;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditInspectorsRespVo;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public class SfaAuditInspectorEntityToResp implements Function<SfaAuditInspectorsEntity, SfaAuditInspectorsRespVo> {
    @Override
    public SfaAuditInspectorsRespVo apply(SfaAuditInspectorsEntity entity) {
        SfaAuditInspectorsRespVo respVo=new SfaAuditInspectorsRespVo();
        BeanUtils.copyProperties(entity,respVo);
        String[] auditAreaList=new String[50];
        String[] auditAreaCodeList=new String[50];
        if (StringUtils.isNotBlank(entity.getAuditArea())){
            auditAreaList=entity.getAuditArea().split(",");
            respVo.setAuditArea(new ArrayList<>(Arrays.asList(auditAreaList)));
        }
        if (StringUtils.isNotBlank(entity.getAuditAreaCode())){
            auditAreaCodeList=entity.getAuditAreaCode().split(",");
            respVo.setAuditAreaCode(new ArrayList<>(Arrays.asList(auditAreaCodeList)));
        }
        return respVo;
    }
}
