package com.biz.crm.audit.utils;

import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.util.Result;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;

import java.util.Map;
import java.util.stream.Collectors;

/**
 * 用于根据稽查区域编码获得稽查区域名称的工具类
 */
public class SfaAuditAreaUtils {

    @Resource
    private MdmOrgFeign mdmOrgFeign;

    public Map<String,String>  getAuditArea(List<String> auditAreas){
        String auditAreaCode=Constant.NULLT;
        String auditArea=Constant.NULLT;
        if (CollectionUtils.isNotEmpty(auditAreas)){
            auditAreaCode= StringUtils.join(auditAreas,",");
        }
        Result<List<MdmOrgRespVo>> listResult = mdmOrgFeign.detailBatchByOrgCodeList(auditAreas);
        List<MdmOrgRespVo> result = listResult.getResult();
        List<String> collect = result.stream().map(MdmOrgRespVo::getOrgName).collect(Collectors.toList());
        auditArea=StringUtils.join(collect,",");
        Map<String,String> resultMap = new HashMap<>();
        resultMap.put("code",auditAreaCode);
        resultMap.put("name",auditArea);
        return resultMap;
    }

}
