package com.biz.crm.base;

import com.biz.crm.service.RedisService;
import com.biz.crm.util.JobHelper;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Map;


/**
 * SFA任务恢复监听器
 *  @author: luoqi
 *  @Date: 2021-5-17 17:15
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Component
@Order
public class SfaJobListener implements ApplicationListener<ApplicationReadyEvent> {
    @Resource
    private RedisService redisService;
    @Resource
    private JobHelper jobHelper;
    @Value("${job.runScheduledTask:false}")
    private Boolean runScheduledTask;

    @Override
    public void onApplicationEvent(ApplicationReadyEvent applicationReadyEvent) {
        if(!this.runScheduledTask){
            log.warn("SFA任务恢复监听器： 该应用实例配置[job.runScheduledTask=false],跳过任务恢复");
            return;
        }
        log.warn("SFA任务恢复监听器： 开始恢复任务执行环境...");
        Map<String, JobHelper.JobContext> jobs = (Map<String, JobHelper.JobContext>) this.redisService.hmget(JobHelper.redisHash);
        log.warn("SFA任务恢复监听器： 计划恢复任务：jobs = {}", JsonPropertyUtil.toJsonString(jobs));
        this.doJobs(jobs);
    }

    protected void doJobs(Map<String, JobHelper.JobContext> jobs){
        jobs.forEach((job, jobContext) -> {
            jobHelper.executeJobAsync(jobContext);
        });
    }



}
