package com.biz.crm.base.attachment;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.AccessLevel;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.Index;


/**
 *  @author: luoqi
 *  @Date: 2021-4-7 15:49
 *  @version: V1.0
 *  @Description:
 */
@Getter
@Setter
@TableName("sfa_attachment")
@CrmTable(name = "sfa_attachment", tableNote = "SFA附件表", indexes = {@Index(name = "sfa_attachment_biz_id_attachment_biz_type", columnList = "biz_id, attachment_biz_type")})
public class SfaAttachmentEntity extends CrmExtTenEntity<SfaAttachmentEntity> {

    @ApiModelProperty("业务类型")
    @CrmColumn(name = "attachment_biz_type", length = 128, note = "业务类型")
    private String attachmentBizType;

    @ApiModelProperty("业务类型")
    @CrmColumn(name = "attachment_biz_type_name", length = 128, note = "业务类型")
    private String attachmentBizTypeName;

    @ApiModelProperty("业务id")
    @CrmColumn(name = "biz_id", length = 32, note = "业务id")
    private String bizId;

    @ApiModelProperty("objectName")
    @CrmColumn(name = "object_name", note = "objectName")
    private String objectName;

    @ApiModelProperty("相对路径")
    @CrmColumn(name = "url_path", note = "相对路径")
    private String urlPath;

    @ApiModelProperty("域名url")
    @CrmColumn(name = "url_path_prefix", length = 128, note = "域名url")
    private String urlPathPrefix;

    @ApiModelProperty("全路径")
    @Getter(AccessLevel.NONE)
    @CrmColumn(name = "url", note = "全路径")
    private String url;

    public String getUrl() {
        if(StringUtils.isBlank(this.url)){
            String urlPath = StringUtils.isBlank(this.objectName) ? this.urlPath : this.objectName;
            return this.urlPathPrefix + urlPath;
        }
        return url;
    }

    @ApiModelProperty("文件名")
    @CrmColumn(name = "file_name", note = "文件名")
    private String fileName;

    @ApiModelProperty("扩展名")
    @CrmColumn(name = "suffix", length = 16, note = "扩展名")
    private String suffix;




}
