package com.biz.crm.base.utils;

import com.biz.crm.base.BusinessException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;

@Slf4j
public class PointUtil {
    private PointUtil(){}
    public static BigDecimal[] splitBigDecimal(String pointStr){
        if(StringUtils.isBlank(pointStr)){
            throw new BusinessException("定位信息为空");
        }
        String[] split = pointStr.split(",");
        if(split.length != 2){
            throw new BusinessException("非法的定位信息[" + pointStr + "],请确认定位权限是否可用！");
        }
        try {
            BigDecimal[] point = new BigDecimal[]{new BigDecimal(split[0]), new BigDecimal(split[1])};
            return point;
        }catch (Exception e){
            String msg = "非法的定位信息[" + pointStr + "],请确认定位权限是否可用！";
            log.error(msg, e);
            throw new BusinessException(msg);
        }

    }
    public static String[] splitString(String pointStr){
        if(StringUtils.isBlank(pointStr)){
            throw new BusinessException("定位信息为空");
        }
        String[] split = pointStr.split(",");
        if(split.length != 2){
            throw new BusinessException("非法的定位信息[" + pointStr + "],请确认定位权限是否可用！");
        }
        try {
            new BigDecimal(split[0]);
            new BigDecimal(split[1]);
            return split;
        }catch (Exception e){
            String msg = "非法的定位信息[" + pointStr + "],请确认定位权限是否可用！";
            log.error(msg, e);
            throw new BusinessException(msg);
        }

    }
}
