package com.biz.crm.base.utils;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmAttachment;
import com.biz.crm.base.CrmAttachmentContainer3;
import com.biz.crm.base.CrmAttachmentContainer6;
import com.biz.crm.base.attachment.ISfaAttachmentService;
import com.biz.crm.base.attachment.SfaAttachmentEntity;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.eunm.sfa.AttachmentBizTypeEnum;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;


/**
 * sfa 附件工具
 *  @author: luoqi
 *  @Date: 2021-4-7 16:23
 *  @version: V1.0
 *  @Description:
 */
public class SfaAttachmentUtil {
    private SfaAttachmentUtil(){}
    private static ISfaAttachmentService sfaAttachmentService = SpringApplicationContextUtil.getApplicationContext().getBean(ISfaAttachmentService.class);

    /**
     * 组装
     * @param attachments
     * @param bizType
     * @param bizId
     */
    public static List<SfaAttachmentEntity> build(List<CrmAttachment> attachments, AttachmentBizTypeEnum bizType, String bizId){
        if(null == bizType){
            throw new BusinessException("请指定附件业务类型");
        }
        return build(attachments, bizType.getVal(), bizType.getDesc(), bizId);
    }
    /**
     * 组装
     * @param attachments
     * @param bizType
     * @param bizId
     */
    public static List<SfaAttachmentEntity> build(List<CrmAttachment> attachments, String bizType, String bizTypeName, String bizId){
        if(CollectionUtils.isEmpty(attachments)){
            return Lists.newArrayList();
        }
        if(StringUtils.isBlank(bizType)){
            throw new BusinessException("请指定附件业务类型");
        }
        if(StringUtils.isBlank(bizId)){
            throw new BusinessException("请指定附件业务ID");
        }
        List<SfaAttachmentEntity> entities = attachments.stream().map(v -> {
            SfaAttachmentEntity entity = CrmBeanUtil.copy(v, SfaAttachmentEntity.class);
            entity.setAttachmentBizType(bizType);
            entity.setAttachmentBizTypeName(bizTypeName);
//            entity.setFullUrl(entity.getUrlPathPrefix() + entity.getUrlPath());
            entity.setBizId(bizId);
            return entity;
        }).collect(Collectors.toList());
        return entities;
    }

    public static void copy(CrmAttachmentContainer6 source, CrmAttachmentContainer6 target){
        if(null == source || null == target){
            return;
        }
        source.setAttachmentExt1(target.getAttachmentExt1());
        source.setAttachmentExt2(target.getAttachmentExt2());
        source.setAttachmentExt3(target.getAttachmentExt3());
        source.setAttachmentExt4(target.getAttachmentExt4());
        source.setAttachmentExt5(target.getAttachmentExt5());
        source.setAttachmentExt6(target.getAttachmentExt6());
    }
    public static void copy(CrmAttachmentContainer3 source, CrmAttachmentContainer3 target){
        if(null == source || null == target){
            return;
        }
        source.setAttachmentExt1(target.getAttachmentExt1());
        source.setAttachmentExt2(target.getAttachmentExt2());
        source.setAttachmentExt3(target.getAttachmentExt3());
    }

    /**
     * 组装
     * @param container6
     */
    public static List<SfaAttachmentEntity> build(CrmAttachmentContainer6 container6){
        if(!checkContainer(container6)){
            return Lists.newArrayList();
        }
        String bizId = container6.getId();
        String attachmentNameScope = container6.attachmentNameScope();
        // 1-3的容器
        List<SfaAttachmentEntity> list = build((CrmAttachmentContainer3)container6);
        // 4-6的容器
        String bizType = attachmentNameScope + CrmAttachmentContainer6.ATTACHMENT_EXT4;
        list.addAll(build(container6.getAttachmentExt4(), bizType, bizType , bizId));
        bizType = attachmentNameScope + CrmAttachmentContainer6.ATTACHMENT_EXT5;
        list.addAll(build(container6.getAttachmentExt5(), bizType, bizType , bizId));
        bizType = attachmentNameScope + CrmAttachmentContainer6.ATTACHMENT_EXT6;
        list.addAll(build(container6.getAttachmentExt6(), bizType, bizType , bizId));
        return list;
    }

    /**
     * 组装
     * @param container3
     */
    public static List<SfaAttachmentEntity> build(CrmAttachmentContainer3 container3){
        if(!checkContainer(container3)){
            return Lists.newArrayList();
        }
        List<SfaAttachmentEntity> list = Lists.newArrayList();
        String bizId = container3.getId();
        String attachmentNameScope = container3.attachmentNameScope();
        String bizType = attachmentNameScope + CrmAttachmentContainer3.ATTACHMENT_EXT1;
        list.addAll(build(container3.getAttachmentExt1(), bizType, bizType , bizId));
        bizType = attachmentNameScope + CrmAttachmentContainer3.ATTACHMENT_EXT2;
        list.addAll(build(container3.getAttachmentExt2(), bizType, bizType , bizId));
        bizType = attachmentNameScope + CrmAttachmentContainer3.ATTACHMENT_EXT3;
        list.addAll(build(container3.getAttachmentExt3(), bizType, bizType , bizId));
        return list;
    }

    protected static boolean checkContainer(CrmAttachmentContainer3 container3){
        if(null == container3){
            return false;
        }
        if(StringUtils.isBlank(container3.getId())){
            return false;
        }
        if(StringUtils.isBlank(container3.attachmentNameScope())){
            return false;
        }
        return true;
    }

    /**
     * 新增
     * @param container3
     */
    public static List<SfaAttachmentEntity> insert(CrmAttachmentContainer3 container3){
        if(null == container3){
            return Lists.newArrayList();
        }
        List<SfaAttachmentEntity> entities;
        if(container3 instanceof CrmAttachmentContainer6){
            entities = build((CrmAttachmentContainer6)container3);
        }else{
            entities = build(container3);
        }
        return insert(entities);
    }

    /**
     * 新增
     * @param attachments
     * @param bizType
     * @param bizId
     */
    public static List<SfaAttachmentEntity> insert(List<CrmAttachment> attachments, AttachmentBizTypeEnum bizType, String bizId){
        List<SfaAttachmentEntity> entities = build(attachments, bizType, bizId);
        return insert(entities);
    }

    /**
     * 新增
     * @param attachments
     * @param bizType
     * @param bizId
     */
    public static List<SfaAttachmentEntity> insert(List<CrmAttachment> attachments, String bizType, String bizTypeName, String bizId){
        List<SfaAttachmentEntity> entities = build(attachments, bizType, bizTypeName, bizId);
        return insert(entities);
    }



    /**
     * 新增
     * @param attachments
     */
    public static List<SfaAttachmentEntity> insert(List<SfaAttachmentEntity> attachments){
        if(CollectionUtils.isEmpty(attachments)){
            return Lists.newArrayList();
        }
        sfaAttachmentService.saveOrUpdateBatch(attachments, 50);
        return attachments;
    }
    /**
     * 删除
     * @param bizType
     * @param bizId
     */
    public static void del(AttachmentBizTypeEnum bizType, String bizId){
        if(null == bizType){
            throw new BusinessException("请指定附件业务类型");
        }
        if(StringUtils.isBlank(bizId)){
            throw new BusinessException("请指定附件业务ID");
        }
        sfaAttachmentService.remove(Wrappers.lambdaQuery(SfaAttachmentEntity.class).eq(SfaAttachmentEntity :: getBizId, bizId).eq(SfaAttachmentEntity :: getAttachmentBizType, bizType.getVal()));
    }
    /**
     * 删除
     * @param bizTypeEnums
     * @param bizId
     */
    public static void delByBizIdInBizTypeEnums(List<AttachmentBizTypeEnum> bizTypeEnums, String bizId){
        if(CollectionUtils.isEmpty(bizTypeEnums)){
            throw new BusinessException("请指定附件业务类型");
        }
        if(StringUtils.isBlank(bizId)){
            throw new BusinessException("请指定附件业务ID");
        }
        sfaAttachmentService.remove(Wrappers.lambdaQuery(SfaAttachmentEntity.class).eq(SfaAttachmentEntity :: getBizId, bizId)
                .in(SfaAttachmentEntity :: getAttachmentBizType, bizTypeEnums.stream().map(AttachmentBizTypeEnum :: getVal).collect(Collectors.toList())));
    }

    /**
     * 删除
     * @param bizType
     * @param bizId
     */
    public static void del(String bizType, String bizId){
        if(StringUtils.isBlank(bizType)){
            throw new BusinessException("请指定附件业务类型");
        }
        if(StringUtils.isBlank(bizId)){
            throw new BusinessException("请指定附件业务ID");
        }
        sfaAttachmentService.remove(Wrappers.lambdaQuery(SfaAttachmentEntity.class).eq(SfaAttachmentEntity :: getBizId, bizId).eq(SfaAttachmentEntity :: getAttachmentBizType, bizType));
    }

    /**
     * 删除
     * @param bizTypes
     * @param bizId
     */
    public static void delByBizIdInBizTypes(List<String> bizTypes, String bizId){
        if(CollectionUtils.isEmpty(bizTypes)){
            throw new BusinessException("请指定附件业务类型");
        }
        if(StringUtils.isBlank(bizId)){
            throw new BusinessException("请指定附件业务ID");
        }
        sfaAttachmentService.remove(Wrappers.lambdaQuery(SfaAttachmentEntity.class).eq(SfaAttachmentEntity :: getBizId, bizId)
                .in(SfaAttachmentEntity :: getAttachmentBizType, bizTypes));
    }

    /**
     * 删除
     * @param ids
     */
    public static void delByIds(List<String> ids){
        if(CollectionUtils.isEmpty(ids)){
            return;
        }
        sfaAttachmentService.removeByIds(ids);
    }


    /**
     * 查询
     * @param bizType
     * @param bizId
     */
    public static List<SfaAttachmentEntity> getList(AttachmentBizTypeEnum bizType, String bizId){
        if(null == bizType){
            return Lists.newArrayList();
        }
        return getList(bizType.getVal(), bizId);
    }

    /**
     * 查询
     * @param bizType
     * @param bizId
     */
    public static List<SfaAttachmentEntity> getList(String bizType, String bizId){
        if(StringUtils.isBlank(bizType)){
            return Lists.newArrayList();
        }
        if(StringUtils.isBlank(bizId)){
            return Lists.newArrayList();
        }
        return sfaAttachmentService.list(Wrappers.lambdaQuery(SfaAttachmentEntity.class).eq(SfaAttachmentEntity :: getBizId, bizId).eq(SfaAttachmentEntity :: getAttachmentBizType, bizType));
    }

    /**
     * 查询
     * @param bizType
     * @param bizIds
     */
    public static List<SfaAttachmentEntity> getList(AttachmentBizTypeEnum bizType, List<String> bizIds){
        if(null == bizType){
            return Lists.newArrayList();
        }
        return getList(bizType.getVal(), bizIds);
    }

    /**
     * 查询
     * @param bizType
     * @param bizIds
     */
    public static List<SfaAttachmentEntity> getList(String bizType, List<String> bizIds){
        if(StringUtils.isBlank(bizType)){
            return Lists.newArrayList();
        }
        if(CollectionUtils.isEmpty(bizIds)){
            return Lists.newArrayList();
        }
        return sfaAttachmentService.list(Wrappers.lambdaQuery(SfaAttachmentEntity.class).in(SfaAttachmentEntity :: getBizId, bizIds).eq(SfaAttachmentEntity :: getAttachmentBizType, bizType));
    }
}
