package com.biz.crm.cache.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.common.param.RedisParam;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.StringUtils;
import com.biz.crm.worksign.model.SfaWorkSignRuleInfoEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.worksign.util
 * @Description: 上下班签到工具类
 * @date 2021/4/7 上午11:49
 */
@Component
public class WorkSignUtil {
    /**
     * redis缓存key
     */
    public static final String redisKey = "SFA_WORK_SIGN_RECORD:v1:";
    @Autowired
    private RedisService redisService;


    //获取编码
    public String getKey(String userName,String ruleDate){
        if(StringUtils.isEmpty(userName)||StringUtils.isEmpty(ruleDate)){
            throw new BusinessException("参数错误");
        }
        return redisKey+userName+ruleDate;
    }

    //删除缓存
    public void deleteKey(String userName,String ruleDate){
        redisService.del(getKey(userName,ruleDate));
    }
    //设置缓存
    public void setObj(SfaWorkSignRuleInfoEntity vo){
        String key = getKey(vo.getUserName(),vo.getRuleDate());
        redisService.setDays(key,vo, RedisParam.TIME30);
    }
    //获取对象
    public SfaWorkSignRuleInfoEntity getObj(String userName,String ruleDate){
        Object o = redisService.get(getKey(userName,ruleDate));
        if(o==null){
            return compensate(userName,ruleDate);
        }
        SfaWorkSignRuleInfoEntity entity = (SfaWorkSignRuleInfoEntity)o;
        if(StringUtils.isEmpty(entity.getUserName())){
            return null;
        }
        return entity;
    }

    //todo 缓存丢失补偿  数据库如果没有设置空对象 UserName 默认空字符串
    public SfaWorkSignRuleInfoEntity compensate(String userName,String ruleDate){
        //todo setObj()
        return null;
    }
}
