package com.biz.crm.calculatesalary.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.calculatesalary.service.ISfaCalculateSalaryDateService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.calculateSalary.req.SfaCalculateSalaryDateReqVo;
import com.biz.crm.nebular.sfa.calculateSalary.resp.SfaCalculateSalaryDateRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 计算薪资日期
 *
 * @author lf
 * @date 2020-12-28 15:00:09
 */
@Slf4j
@RestController
@RequestMapping("/sfaCalculateSalaryDateController")
@Api(tags = "计算薪资日期")
public class SfaCalculateSalaryDateController {
    @Autowired
    private ISfaCalculateSalaryDateService sfaCalculateSalaryDateService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaCalculateSalaryDateRespVo>> list(@RequestBody SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo) {
        PageResult<SfaCalculateSalaryDateRespVo> result=sfaCalculateSalaryDateService.findList(sfaCalculateSalaryDateReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaCalculateSalaryDateRespVo> query(@RequestBody SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo) {
        SfaCalculateSalaryDateRespVo respVo=sfaCalculateSalaryDateService.query(sfaCalculateSalaryDateReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo) {
        sfaCalculateSalaryDateService.save(sfaCalculateSalaryDateReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo) {
        sfaCalculateSalaryDateService.update(sfaCalculateSalaryDateReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo) {
        sfaCalculateSalaryDateService.deleteBatch(sfaCalculateSalaryDateReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo) {
        sfaCalculateSalaryDateService.enableBatch(sfaCalculateSalaryDateReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo) {
        sfaCalculateSalaryDateService.disableBatch(sfaCalculateSalaryDateReqVo);
        return Result.ok("禁用成功");
    }
}
