package com.biz.crm.calculatesalary.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.calculatesalary.service.ISfaCalculateSalaryYearService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.calculateSalary.req.SfaCalculateSalaryYearReqVo;
import com.biz.crm.nebular.sfa.calculateSalary.resp.SfaCalculateSalaryYearRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 计算薪资年 
 *
 * @author lf
 * @date 2020-12-28 15:00:09
 */
@Slf4j
@RestController
@RequestMapping("/sfaCalculateSalaryYearController")
@Api(tags = "计算薪资年 ")
public class SfaCalculateSalaryYearController {
    @Autowired
    private ISfaCalculateSalaryYearService sfaCalculateSalaryYearService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaCalculateSalaryYearRespVo>> list(@RequestBody SfaCalculateSalaryYearReqVo sfaCalculateSalaryYearReqVo) {
        PageResult<SfaCalculateSalaryYearRespVo> result=sfaCalculateSalaryYearService.findList(sfaCalculateSalaryYearReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "通过id查询详情")
    @GetMapping("/queryDetailById")
    @CrmLog
    public Result<SfaCalculateSalaryYearRespVo> queryDetailById(@RequestParam String id) {
        SfaCalculateSalaryYearRespVo respVo=sfaCalculateSalaryYearService.queryDetailById(id);
        return Result.ok(respVo);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaCalculateSalaryYearRespVo> query(@RequestBody SfaCalculateSalaryYearReqVo sfaCalculateSalaryYearReqVo) {
        SfaCalculateSalaryYearRespVo respVo=sfaCalculateSalaryYearService.query(sfaCalculateSalaryYearReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaCalculateSalaryYearReqVo sfaCalculateSalaryYearReqVo) {
        sfaCalculateSalaryYearService.save(sfaCalculateSalaryYearReqVo);
        return Result.ok();
    }


    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaCalculateSalaryYearReqVo sfaCalculateSalaryYearReqVo) {
        sfaCalculateSalaryYearService.update(sfaCalculateSalaryYearReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        sfaCalculateSalaryYearService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        sfaCalculateSalaryYearService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        sfaCalculateSalaryYearService.disableBatch(ids);
        return Result.ok("禁用成功");
    }

    /**
     * 查询年份列表
     * @return
     */
    @ApiOperation(value = "查询年份列表")
    @GetMapping("/getYearList")
    @CrmLog
    public Result<List<String>> getYearList(){
        Result result = new Result();
        List<String> yearList = sfaCalculateSalaryYearService.getYearList();
        result.setResult(yearList);
        return result;
    }
}
