package com.biz.crm.calculatesalary.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 计算薪资年 实体类
 *
 * @author lf
 * @date 2020-12-28 15:00:09
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_calculate_salary_year")
@CrmTable(name = "sfa_calculate_salary_year", tableNote = "计算薪资年")
public class SfaCalculateSalaryYearEntity extends CrmExtTenEntity<SfaCalculateSalaryYearEntity> {

    /**
     * 年份
     */
    @CrmColumn(name = "year", length = 4, note = "年份")
    private String year;

    /**
     * 法定节假日天数
     */
    @CrmColumn(name = "holiday_days", length = 5, note = "法定节假日天数")
    private String holidayDays;

    /**
     * 计算薪资天数
     */
    @CrmColumn(name = "salary_days", length = 5, note = "计算薪资天数")
    private String salaryDays;

    /**
     * 人员账号
     */
    @CrmColumn(name = "user_name", length = 50, note = "人员账号")
    private String userName;

    /**
     * 真实姓名
     */
    @CrmColumn(name = "real_name", length = 50, note = "真实姓名")
    private String realName;

    /**
     * 组织编码
     */
    @CrmColumn(name = "org_code", length = 50, note = "组织编码")
    private String orgCode;

    /**
     * 组织名称
     */
    @CrmColumn(name = "org_name", length = 50, note = "组织名称")
    private String orgName;

    /**
     * 职位编码
     */
    @CrmColumn(name = "pos_code", length = 50, note = "职位编码")
    private String posCode;

    /**
     * 职位名称
     */
    @CrmColumn(name = "pos_name", length = 50, note = "职位名称")
    private String posName;

}
